/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jaxen.dom;

import com.elixirtech.jaxen.DefaultNavigator;
import com.elixirtech.jaxen.FunctionCallException;
import com.elixirtech.jaxen.JaxenConstants;
import com.elixirtech.jaxen.Navigator;
import com.elixirtech.jaxen.XPath;
import com.elixirtech.jaxen.dom.DOMXPath;
import com.elixirtech.jaxen.dom.NamespaceNode;
import com.elixirtech.jaxen.saxpath.SAXPathException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public class DocumentNavigator
extends DefaultNavigator {
    private static final long serialVersionUID = 8460943068889528115L;
    private static final DocumentNavigator SINGLETON = new DocumentNavigator();

    public static Navigator getInstance() {
        return SINGLETON;
    }

    @Override
    public Iterator getChildAxisIterator(Object object) {
        return new NodeIterator((Node)object){

            @Override
            protected Node getFirstNode(Node node) {
                return node.getFirstChild();
            }

            @Override
            protected Node getNextNode(Node node) {
                return node.getNextSibling();
            }
        };
    }

    @Override
    public Iterator getParentAxisIterator(Object object) {
        Node node = (Node)object;
        if (node.getNodeType() == 2) {
            return new NodeIterator(node){

                @Override
                protected Node getFirstNode(Node node) {
                    return ((Attr)node).getOwnerElement();
                }

                @Override
                protected Node getNextNode(Node node) {
                    return null;
                }
            };
        }
        return new NodeIterator(node){

            @Override
            protected Node getFirstNode(Node node) {
                return node.getParentNode();
            }

            @Override
            protected Node getNextNode(Node node) {
                return null;
            }
        };
    }

    @Override
    public Object getParentNode(Object object) {
        Node node = (Node)object;
        if (node.getNodeType() == 2) {
            return ((Attr)node).getOwnerElement();
        }
        return node.getParentNode();
    }

    @Override
    public Iterator getFollowingSiblingAxisIterator(Object object) {
        return new NodeIterator((Node)object){

            @Override
            protected Node getFirstNode(Node node) {
                return this.getNextNode(node);
            }

            @Override
            protected Node getNextNode(Node node) {
                return node.getNextSibling();
            }
        };
    }

    @Override
    public Iterator getPrecedingSiblingAxisIterator(Object object) {
        return new NodeIterator((Node)object){

            @Override
            protected Node getFirstNode(Node node) {
                return this.getNextNode(node);
            }

            @Override
            protected Node getNextNode(Node node) {
                return node.getPreviousSibling();
            }
        };
    }

    @Override
    public Iterator getFollowingAxisIterator(Object object) {
        return new NodeIterator((Node)object){

            @Override
            protected Node getFirstNode(Node node) {
                if (node == null) {
                    return null;
                }
                Node node2 = node.getNextSibling();
                if (node2 == null) {
                    return this.getFirstNode(node.getParentNode());
                }
                return node2;
            }

            @Override
            protected Node getNextNode(Node node) {
                if (node == null) {
                    return null;
                }
                Node node2 = node.getFirstChild();
                if (node2 == null) {
                    node2 = node.getNextSibling();
                }
                if (node2 == null) {
                    return this.getFirstNode(node.getParentNode());
                }
                return node2;
            }
        };
    }

    @Override
    public Iterator getAttributeAxisIterator(Object object) {
        if (this.isElement(object)) {
            return new AttributeIterator((Node)object);
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    @Override
    public Iterator getNamespaceAxisIterator(Object object) {
        if (this.isElement(object)) {
            Node node;
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            for (node = (Node)object; node != null; node = node.getParentNode()) {
                Object object2;
                Object object3;
                String string;
                Attr attr;
                int n;
                Object object4;
                String string2 = node.getNamespaceURI();
                if (string2 != null && !"".equals(string2) && !hashMap.containsKey(object4 = node.getPrefix())) {
                    NamespaceNode namespaceNode = new NamespaceNode((Node)object, (String)object4, string2);
                    hashMap.put(object4, namespaceNode);
                }
                if (!node.hasAttributes()) continue;
                object4 = node.getAttributes();
                int n2 = object4.getLength();
                for (n = 0; n < n2; ++n) {
                    attr = (Attr)object4.item(n);
                    string = attr.getNamespaceURI();
                    if ("http://www.w3.org/2000/xmlns/".equals(string) || string == null) continue;
                    object3 = attr.getPrefix();
                    object2 = new NamespaceNode((Node)object, (String)object3, string);
                    if (hashMap.containsKey(object3)) continue;
                    hashMap.put(object3, object2);
                }
                for (n = 0; n < n2; ++n) {
                    attr = (Attr)object4.item(n);
                    string = attr.getNamespaceURI();
                    if (!"http://www.w3.org/2000/xmlns/".equals(string) || hashMap.containsKey(object2 = ((NamespaceNode)(object3 = new NamespaceNode((Node)object, attr))).getNodeName())) continue;
                    hashMap.put(object2, object3);
                }
            }
            hashMap.put("xml", new NamespaceNode((Node)object, "xml", "http://www.w3.org/XML/1998/namespace"));
            node = (NamespaceNode)hashMap.get("");
            if (node != null && ((NamespaceNode)node).getNodeValue().length() == 0) {
                hashMap.remove("");
            }
            return hashMap.values().iterator();
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    @Override
    public XPath parseXPath(String string) throws SAXPathException {
        return new DOMXPath(string);
    }

    @Override
    public Object getDocumentNode(Object object) {
        if (this.isDocument(object)) {
            return object;
        }
        return ((Node)object).getOwnerDocument();
    }

    @Override
    public String getElementNamespaceUri(Object object) {
        try {
            Node node = (Node)object;
            if (node.getNodeType() == 1) {
                return node.getNamespaceURI();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getElementName(Object object) {
        if (this.isElement(object)) {
            String string = ((Node)object).getLocalName();
            if (string == null) {
                string = ((Node)object).getNodeName();
            }
            return string;
        }
        return null;
    }

    @Override
    public String getElementQName(Object object) {
        try {
            Node node = (Node)object;
            if (node.getNodeType() == 1) {
                return node.getNodeName();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getAttributeNamespaceUri(Object object) {
        try {
            Node node = (Node)object;
            if (node.getNodeType() == 2) {
                return node.getNamespaceURI();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getAttributeName(Object object) {
        if (this.isAttribute(object)) {
            String string = ((Node)object).getLocalName();
            if (string == null) {
                string = ((Node)object).getNodeName();
            }
            return string;
        }
        return null;
    }

    @Override
    public String getAttributeQName(Object object) {
        try {
            Node node = (Node)object;
            if (node.getNodeType() == 2) {
                return node.getNodeName();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isDocument(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 9;
    }

    @Override
    public boolean isNamespace(Object object) {
        return object instanceof NamespaceNode;
    }

    @Override
    public boolean isElement(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 1;
    }

    @Override
    public boolean isAttribute(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 2 && !"http://www.w3.org/2000/xmlns/".equals(((Node)object).getNamespaceURI());
    }

    @Override
    public boolean isComment(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 8;
    }

    @Override
    public boolean isText(Object object) {
        if (object instanceof Node) {
            switch (((Node)object).getNodeType()) {
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isProcessingInstruction(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 7;
    }

    @Override
    public String getElementStringValue(Object object) {
        if (this.isElement(object)) {
            return this.getStringValue((Node)object, new StringBuffer()).toString();
        }
        return null;
    }

    private StringBuffer getStringValue(Node node, StringBuffer stringBuffer) {
        if (this.isText(node)) {
            stringBuffer.append(node.getNodeValue());
        } else {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                this.getStringValue(nodeList.item(i), stringBuffer);
            }
        }
        return stringBuffer;
    }

    @Override
    public String getAttributeStringValue(Object object) {
        if (this.isAttribute(object)) {
            return ((Node)object).getNodeValue();
        }
        return null;
    }

    @Override
    public String getTextStringValue(Object object) {
        if (this.isText(object)) {
            return ((Node)object).getNodeValue();
        }
        return null;
    }

    @Override
    public String getCommentStringValue(Object object) {
        if (this.isComment(object)) {
            return ((Node)object).getNodeValue();
        }
        return null;
    }

    @Override
    public String getNamespaceStringValue(Object object) {
        if (this.isNamespace(object)) {
            return ((NamespaceNode)object).getNodeValue();
        }
        return null;
    }

    @Override
    public String getNamespacePrefix(Object object) {
        if (this.isNamespace(object)) {
            return ((NamespaceNode)object).getLocalName();
        }
        return null;
    }

    @Override
    public String translateNamespacePrefixToUri(String string, Object object) {
        Iterator iterator = this.getNamespaceAxisIterator(object);
        while (iterator.hasNext()) {
            NamespaceNode namespaceNode = (NamespaceNode)iterator.next();
            if (!string.equals(namespaceNode.getNodeName())) continue;
            return namespaceNode.getNodeValue();
        }
        return null;
    }

    @Override
    public Object getDocument(String string) throws FunctionCallException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(string);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new FunctionCallException("JAXP setup error in document() function: " + parserConfigurationException.getMessage(), parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new FunctionCallException("XML error in document() function: " + sAXException.getMessage(), sAXException);
        }
        catch (IOException iOException) {
            throw new FunctionCallException("I/O error in document() function: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public String getProcessingInstructionTarget(Object object) {
        if (this.isProcessingInstruction(object)) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)object;
            return processingInstruction.getTarget();
        }
        throw new ClassCastException(object + " is not a processing instruction");
    }

    @Override
    public String getProcessingInstructionData(Object object) {
        if (this.isProcessingInstruction(object)) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)object;
            return processingInstruction.getData();
        }
        throw new ClassCastException(object + " is not a processing instruction");
    }

    @Override
    public Object getElementById(Object object, String string) {
        Document document = (Document)this.getDocumentNode(object);
        if (document != null) {
            return document.getElementById(string);
        }
        return null;
    }

    private static class AttributeIterator
    implements Iterator<Object> {
        private NamedNodeMap map;
        private int pos;
        private int lastAttribute = -1;

        AttributeIterator(Node node) {
            this.map = node.getAttributes();
            this.pos = 0;
            for (int i = this.map.getLength() - 1; i >= 0; --i) {
                Node node2 = this.map.item(i);
                if ("http://www.w3.org/2000/xmlns/".equals(node2.getNamespaceURI())) continue;
                this.lastAttribute = i;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.pos <= this.lastAttribute;
        }

        @Override
        public Object next() {
            Node node;
            if ((node = this.map.item(this.pos++)) == null) {
                throw new NoSuchElementException();
            }
            if ("http://www.w3.org/2000/xmlns/".equals(node.getNamespaceURI())) {
                return this.next();
            }
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    abstract class NodeIterator
    implements Iterator<Object> {
        private Node node;

        public NodeIterator(Node node) {
            this.node = this.getFirstNode(node);
            while (!this.isXPathNode(this.node)) {
                this.node = this.getNextNode(this.node);
            }
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        @Override
        public Object next() {
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            Node node = this.node;
            this.node = this.getNextNode(this.node);
            while (!this.isXPathNode(this.node)) {
                this.node = this.getNextNode(this.node);
            }
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract Node getFirstNode(Node var1);

        protected abstract Node getNextNode(Node var1);

        private boolean isXPathNode(Node node) {
            if (node == null) {
                return true;
            }
            switch (node.getNodeType()) {
                case 5: 
                case 6: 
                case 10: 
                case 11: 
                case 12: {
                    return false;
                }
            }
            return true;
        }
    }
}

