/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jaxen.function;

import com.elixirtech.jaxen.Context;
import com.elixirtech.jaxen.Function;
import com.elixirtech.jaxen.FunctionCallException;
import com.elixirtech.jaxen.Navigator;
import java.util.List;

public class BooleanFunction
implements Function {
    @Override
    public Object call(Context context, List list) throws FunctionCallException {
        if (list.size() == 1) {
            return BooleanFunction.evaluate(list.get(0), context.getNavigator());
        }
        throw new FunctionCallException("boolean() requires one argument");
    }

    public static Boolean evaluate(Object object, Navigator navigator) {
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() == 0) {
                return Boolean.FALSE;
            }
            object = list.get(0);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d == 0.0 || Double.isNaN(d)) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (object instanceof String) {
            return ((String)object).length() > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return object != null ? Boolean.TRUE : Boolean.FALSE;
    }
}

