/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jaxen.function;

import com.elixirtech.jaxen.Context;
import com.elixirtech.jaxen.Function;
import com.elixirtech.jaxen.FunctionCallException;
import com.elixirtech.jaxen.Navigator;
import com.elixirtech.jaxen.function.StringFunction;
import java.util.Iterator;
import java.util.List;

public class NumberFunction
implements Function {
    private static final Double NaN = new Double(Double.NaN);

    @Override
    public Object call(Context context, List list) throws FunctionCallException {
        if (list.size() == 1) {
            return NumberFunction.evaluate(list.get(0), context.getNavigator());
        }
        if (list.size() == 0) {
            return NumberFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        throw new FunctionCallException("number() takes at most one argument.");
    }

    public static Double evaluate(Object object, Navigator navigator) {
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            try {
                Double d = new Double(string);
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                return NaN;
            }
        }
        if (object instanceof List || object instanceof Iterator) {
            return NumberFunction.evaluate(StringFunction.evaluate(object, navigator), navigator);
        }
        if (navigator.isElement(object) || navigator.isAttribute(object)) {
            return NumberFunction.evaluate(StringFunction.evaluate(object, navigator), navigator);
        }
        if (object instanceof Boolean) {
            if (object == Boolean.TRUE) {
                return new Double(1.0);
            }
            return new Double(0.0);
        }
        return NaN;
    }

    public static boolean isNaN(double d) {
        return Double.isNaN(d);
    }

    public static boolean isNaN(Double d) {
        return d.equals(NaN);
    }
}

