/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jdom;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import javax.naming.NamingException;
import org.xml.sax.SAXException;

public class JDOMException
extends Exception {
    private Throwable cause;

    public JDOMException() {
        super("Error occurred in JDOM application.");
    }

    public JDOMException(String string) {
        super(string);
    }

    public JDOMException(String string, Throwable throwable) {
        super(string);
        this.cause = throwable;
    }

    @Override
    public Throwable initCause(Throwable throwable) {
        this.cause = throwable;
        return this;
    }

    @Override
    public String getMessage() {
        Throwable throwable;
        Object object = super.getMessage();
        Throwable throwable2 = this;
        while ((throwable = JDOMException.getNestedException(throwable2)) != null) {
            Exception exception;
            String string = throwable.getMessage();
            if (throwable instanceof SAXException && (exception = ((SAXException)throwable).getException()) != null && string != null && string.equals(exception.getMessage())) {
                string = null;
            }
            if (string != null) {
                object = object != null ? (String)object + ": " + string : string;
            }
            if (throwable instanceof JDOMException) break;
            throwable2 = throwable;
        }
        return object;
    }

    @Override
    public void printStackTrace() {
        Throwable throwable;
        super.printStackTrace();
        Throwable throwable2 = this;
        while ((throwable = JDOMException.getNestedException(throwable2)) != null) {
            System.err.print("Caused by: ");
            throwable.printStackTrace();
            if (throwable instanceof JDOMException) break;
            throwable2 = throwable;
        }
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        Throwable throwable;
        super.printStackTrace(printStream);
        Throwable throwable2 = this;
        while ((throwable = JDOMException.getNestedException(throwable2)) != null) {
            printStream.print("Caused by: ");
            throwable.printStackTrace(printStream);
            if (throwable instanceof JDOMException) break;
            throwable2 = throwable;
        }
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        Throwable throwable;
        super.printStackTrace(printWriter);
        Throwable throwable2 = this;
        while ((throwable = JDOMException.getNestedException(throwable2)) != null) {
            printWriter.print("Caused by: ");
            throwable.printStackTrace(printWriter);
            if (throwable instanceof JDOMException) break;
            throwable2 = throwable;
        }
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    private static Throwable getNestedException(Throwable throwable) {
        if (throwable instanceof JDOMException) {
            return ((JDOMException)throwable).getCause();
        }
        if (throwable instanceof SAXException) {
            return ((SAXException)throwable).getException();
        }
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable instanceof ExceptionInInitializerError) {
            return ((ExceptionInInitializerError)throwable).getException();
        }
        if (throwable instanceof RemoteException) {
            return ((RemoteException)throwable).detail;
        }
        if (throwable instanceof NamingException) {
            return ((NamingException)throwable).getRootCause();
        }
        return throwable.getCause();
    }
}

