/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jdom.input;

import com.elixirtech.jdom.Attribute;
import com.elixirtech.jdom.DefaultJDOMFactory;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.EntityRef;
import com.elixirtech.jdom.JDOMFactory;
import com.elixirtech.jdom.Namespace;
import com.elixirtech.jdom.Parent;
import com.elixirtech.jdom.input.TextBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXHandler
extends DefaultHandler
implements LexicalHandler,
DeclHandler,
DTDHandler {
    private static final Map<String, Object> attrNameToTypeMap = new HashMap<String, Object>(13);
    private Document document;
    private Element currentElement;
    private boolean atRoot;
    private boolean inDTD;
    private boolean inInternalSubset;
    private boolean previousCDATA;
    private boolean inCDATA;
    private boolean expand = true;
    private boolean suppress;
    private int entityDepth;
    private List<Namespace> declaredNamespaces;
    private StringBuffer internalSubset = new StringBuffer();
    private TextBuffer textBuffer = new TextBuffer();
    private Map<String, Object> externalEntities;
    private JDOMFactory factory;
    private boolean ignoringWhite;
    private Locator locator;

    public SAXHandler() {
        this(null);
    }

    public SAXHandler(JDOMFactory jDOMFactory) {
        this.factory = jDOMFactory != null ? jDOMFactory : new DefaultJDOMFactory();
        this.atRoot = true;
        this.declaredNamespaces = new ArrayList<Namespace>();
        this.externalEntities = new HashMap<String, Object>();
        this.document = this.factory.document(null);
    }

    protected void pushElement(Element element) {
        if (this.atRoot) {
            this.document.setRootElement(element);
            this.atRoot = false;
        } else {
            this.factory.addContent(this.currentElement, element);
        }
        this.currentElement = element;
    }

    public Document getDocument() {
        return this.document;
    }

    public JDOMFactory getFactory() {
        return this.factory;
    }

    public void setExpandEntities(boolean bl) {
        this.expand = bl;
    }

    public boolean getExpandEntities() {
        return this.expand;
    }

    public void setIgnoringElementContentWhitespace(boolean bl) {
        this.ignoringWhite = bl;
    }

    public boolean getIgnoringElementContentWhitespace() {
        return this.ignoringWhite;
    }

    @Override
    public void startDocument() {
        if (this.locator != null) {
            this.document.setBaseURI(this.locator.getSystemId());
        }
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        this.externalEntities.put(string, new String[]{string2, string3});
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!ENTITY ").append(string);
        this.appendExternalId(string2, string3);
        this.internalSubset.append(">\n");
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!ATTLIST ").append(string).append(' ').append(string2).append(' ').append(string3).append(' ');
        if (string4 != null) {
            this.internalSubset.append(string4);
        } else {
            this.internalSubset.append('\"').append(string5).append('\"');
        }
        if (string4 != null && string4.equals("#FIXED")) {
            this.internalSubset.append(" \"").append(string5).append('\"');
        }
        this.internalSubset.append(">\n");
    }

    @Override
    public void elementDecl(String string, String string2) throws SAXException {
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!ELEMENT ").append(string).append(' ').append(string2).append(">\n");
    }

    @Override
    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!ENTITY ");
        if (string.startsWith("%")) {
            this.internalSubset.append("% ").append(string.substring(1));
        } else {
            this.internalSubset.append(string);
        }
        this.internalSubset.append(" \"").append(string2).append("\">\n");
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.suppress) {
            return;
        }
        this.flushCharacters();
        if (this.atRoot) {
            this.factory.addContent(this.document, this.factory.processingInstruction(string, string2));
        } else {
            this.factory.addContent(this.getCurrentElement(), this.factory.processingInstruction(string, string2));
        }
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        if (string.startsWith("%")) {
            return;
        }
        this.flushCharacters();
        this.factory.addContent(this.getCurrentElement(), this.factory.entityRef(string));
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.suppress) {
            return;
        }
        Namespace namespace = Namespace.getNamespace(string, string2);
        this.declaredNamespaces.add(namespace);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.suppress) {
            return;
        }
        Element element = null;
        if (string != null && !string.equals("")) {
            String string4 = "";
            if (!string3.equals(string2)) {
                int n = string3.indexOf(":");
                string4 = string3.substring(0, n);
            }
            Namespace namespace = Namespace.getNamespace(string4, string);
            element = this.factory.element(string2, namespace);
        } else {
            element = this.factory.element(string2);
        }
        if (this.declaredNamespaces.size() > 0) {
            this.transferNamespaces(element);
        }
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            Attribute attribute = null;
            String string5 = attributes.getLocalName(i);
            String string6 = attributes.getQName(i);
            int n2 = SAXHandler.getAttributeType(attributes.getType(i));
            if (string6.startsWith("xmlns:") || string6.equals("xmlns")) continue;
            if (!string6.equals(string5)) {
                String string7 = string6.substring(0, string6.indexOf(":"));
                Namespace namespace = Namespace.getNamespace(string7, attributes.getURI(i));
                attribute = this.factory.attribute(string5, attributes.getValue(i), n2, namespace);
            } else {
                attribute = this.factory.attribute(string5, attributes.getValue(i), n2);
            }
            this.factory.setAttribute(element, attribute);
        }
        this.flushCharacters();
        if (this.atRoot) {
            this.document.setRootElement(element);
            this.atRoot = false;
        } else {
            this.factory.addContent(this.getCurrentElement(), element);
        }
        this.currentElement = element;
    }

    private void transferNamespaces(Element element) {
        for (Namespace namespace : this.declaredNamespaces) {
            if (namespace == element.getNamespace()) continue;
            element.addNamespaceDeclaration(namespace);
        }
        this.declaredNamespaces.clear();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.suppress || n2 == 0) {
            return;
        }
        if (this.previousCDATA != this.inCDATA) {
            this.flushCharacters();
        }
        this.textBuffer.append(cArray, n, n2);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (!this.ignoringWhite) {
            this.characters(cArray, n, n2);
        }
    }

    protected void flushCharacters() throws SAXException {
        this.flushCharacters(this.textBuffer.toString());
        this.textBuffer.clear();
    }

    protected void flushCharacters(String string) throws SAXException {
        if (string.length() == 0) {
            this.previousCDATA = this.inCDATA;
            return;
        }
        if (this.previousCDATA) {
            this.factory.addContent(this.getCurrentElement(), this.factory.cdata(string));
        } else {
            this.factory.addContent(this.getCurrentElement(), this.factory.text(string));
        }
        this.previousCDATA = this.inCDATA;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.suppress) {
            return;
        }
        this.flushCharacters();
        if (!this.atRoot) {
            Parent parent = this.currentElement.getParent();
            if (parent instanceof Document) {
                this.atRoot = true;
            } else {
                this.currentElement = (Element)parent;
            }
        } else {
            throw new SAXException("Ill-formed XML document (missing opening tag for " + string2 + ")");
        }
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.flushCharacters();
        this.factory.addContent(this.document, this.factory.docType(string, string2, string3));
        this.inDTD = true;
        this.inInternalSubset = true;
    }

    @Override
    public void endDTD() throws SAXException {
        this.document.getDocType().setInternalSubset(this.internalSubset.toString());
        this.inDTD = false;
        this.inInternalSubset = false;
    }

    @Override
    public void startEntity(String string) throws SAXException {
        ++this.entityDepth;
        if (this.expand || this.entityDepth > 1) {
            return;
        }
        if (string.equals("[dtd]")) {
            this.inInternalSubset = false;
            return;
        }
        if (!(this.inDTD || string.equals("amp") || string.equals("lt") || string.equals("gt") || string.equals("apos") || string.equals("quot") || this.expand)) {
            String string2 = null;
            String string3 = null;
            String[] stringArray = (String[])this.externalEntities.get(string);
            if (stringArray != null) {
                string2 = stringArray[0];
                string3 = stringArray[1];
            }
            if (!this.atRoot) {
                this.flushCharacters();
                EntityRef entityRef = this.factory.entityRef(string, string2, string3);
                this.factory.addContent(this.getCurrentElement(), entityRef);
            }
            this.suppress = true;
        }
    }

    @Override
    public void endEntity(String string) throws SAXException {
        --this.entityDepth;
        if (this.entityDepth == 0) {
            this.suppress = false;
        }
        if (string.equals("[dtd]")) {
            this.inInternalSubset = true;
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.suppress) {
            return;
        }
        this.inCDATA = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.suppress) {
            return;
        }
        this.previousCDATA = true;
        this.inCDATA = false;
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.suppress) {
            return;
        }
        this.flushCharacters();
        String string = new String(cArray, n, n2);
        if (this.inDTD && this.inInternalSubset && !this.expand) {
            this.internalSubset.append("  <!--").append(string).append("-->\n");
            return;
        }
        if (!this.inDTD && !string.equals("")) {
            if (this.atRoot) {
                this.factory.addContent(this.document, this.factory.comment(string));
            } else {
                this.factory.addContent(this.getCurrentElement(), this.factory.comment(string));
            }
        }
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!NOTATION ").append(string);
        this.appendExternalId(string2, string3);
        this.internalSubset.append(">\n");
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!ENTITY ").append(string);
        this.appendExternalId(string2, string3);
        this.internalSubset.append(" NDATA ").append(string4);
        this.internalSubset.append(">\n");
    }

    private void appendExternalId(String string, String string2) {
        if (string != null) {
            this.internalSubset.append(" PUBLIC \"").append(string).append('\"');
        }
        if (string2 != null) {
            if (string == null) {
                this.internalSubset.append(" SYSTEM ");
            } else {
                this.internalSubset.append(' ');
            }
            this.internalSubset.append('\"').append(string2).append('\"');
        }
    }

    public Element getCurrentElement() throws SAXException {
        if (this.currentElement == null) {
            throw new SAXException("Ill-formed XML document (multiple root elements detected)");
        }
        return this.currentElement;
    }

    private static int getAttributeType(String string) {
        Integer n = (Integer)attrNameToTypeMap.get(string);
        if (n == null) {
            if (string != null && string.length() > 0 && string.charAt(0) == '(') {
                return 10;
            }
            return 0;
        }
        return n;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    static {
        attrNameToTypeMap.put("CDATA", 1);
        attrNameToTypeMap.put("ID", 2);
        attrNameToTypeMap.put("IDREF", 3);
        attrNameToTypeMap.put("IDREFS", 4);
        attrNameToTypeMap.put("ENTITY", 5);
        attrNameToTypeMap.put("ENTITIES", 6);
        attrNameToTypeMap.put("NMTOKEN", 7);
        attrNameToTypeMap.put("NMTOKENS", 8);
        attrNameToTypeMap.put("NOTATION", 9);
        attrNameToTypeMap.put("ENUMERATION", 10);
    }
}

