/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jdom.output;

import com.elixirtech.jdom.Attribute;
import com.elixirtech.jdom.CDATA;
import com.elixirtech.jdom.Comment;
import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.DocType;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.EntityRef;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.Namespace;
import com.elixirtech.jdom.ProcessingInstruction;
import com.elixirtech.jdom.Text;
import com.elixirtech.jdom.adapters.DOMAdapter;
import com.elixirtech.jdom.output.NamespaceStack;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class DOMOutputter {
    private static final String DEFAULT_ADAPTER_CLASS = "com.elixirtech.jdom.adapters.JAXPDOMAdapter";
    private String adapterClass;

    public DOMOutputter() {
    }

    public DOMOutputter(String string) {
        this.adapterClass = string;
    }

    public org.w3c.dom.Document output(Document document) throws JDOMException {
        NamespaceStack namespaceStack = new NamespaceStack();
        org.w3c.dom.Document document2 = null;
        try {
            DocType docType = document.getDocType();
            document2 = this.createDOMDocument(docType);
            for (Content content : document.getContent()) {
                Node node;
                Content content2;
                if (content instanceof Element) {
                    content2 = (Element)content;
                    node = this.output((Element)content2, document2, namespaceStack);
                    org.w3c.dom.Element element = document2.getDocumentElement();
                    if (element == null) {
                        document2.appendChild(node);
                        continue;
                    }
                    document2.replaceChild(node, element);
                    continue;
                }
                if (content instanceof Comment) {
                    content2 = (Comment)content;
                    node = document2.createComment(((Comment)content2).getText());
                    document2.appendChild(node);
                    continue;
                }
                if (content instanceof ProcessingInstruction) {
                    content2 = (ProcessingInstruction)content;
                    node = document2.createProcessingInstruction(((ProcessingInstruction)content2).getTarget(), ((ProcessingInstruction)content2).getData());
                    document2.appendChild(node);
                    continue;
                }
                if (content instanceof DocType) continue;
                throw new JDOMException("Document contained top-level content with type:" + content.getClass().getName());
            }
        }
        catch (Throwable throwable) {
            throw new JDOMException("Exception outputting Document", throwable);
        }
        return document2;
    }

    private org.w3c.dom.Document createDOMDocument(DocType docType) throws JDOMException {
        if (this.adapterClass != null) {
            try {
                DOMAdapter dOMAdapter = (DOMAdapter)Class.forName(this.adapterClass).newInstance();
                return dOMAdapter.createDocument(docType);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {}
        } else {
            try {
                DOMAdapter dOMAdapter = (DOMAdapter)Class.forName(DEFAULT_ADAPTER_CLASS).newInstance();
                return dOMAdapter.createDocument(docType);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        try {
            DOMAdapter dOMAdapter = (DOMAdapter)Class.forName(DEFAULT_ADAPTER_CLASS).newInstance();
            return dOMAdapter.createDocument(docType);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        throw new JDOMException("No JAXP or default parser available");
    }

    private org.w3c.dom.Element output(Element element, org.w3c.dom.Document document, NamespaceStack namespaceStack) throws JDOMException {
        try {
            String string;
            Object object;
            Object object2;
            int n = namespaceStack.size();
            org.w3c.dom.Element element2 = null;
            element2 = element.getNamespace() == Namespace.NO_NAMESPACE ? document.createElement(element.getQualifiedName()) : document.createElementNS(element.getNamespaceURI(), element.getQualifiedName());
            Namespace namespace = element.getNamespace();
            if (namespace != Namespace.XML_NAMESPACE && (namespace != Namespace.NO_NAMESPACE || namespaceStack.getURI("") != null)) {
                Iterator<Object> iterator = namespace.getPrefix();
                String object3 = namespaceStack.getURI((String)((Object)iterator));
                if (!namespace.getURI().equals(object3)) {
                    namespaceStack.push(namespace);
                    object2 = DOMOutputter.getXmlnsTagFor(namespace);
                    element2.setAttribute((String)object2, namespace.getURI());
                }
            }
            for (Namespace namespace2 : element.getAdditionalNamespaces()) {
                object2 = namespace2.getPrefix();
                object = namespaceStack.getURI((String)object2);
                if (namespace2.getURI().equals(object)) continue;
                string = DOMOutputter.getXmlnsTagFor(namespace2);
                element2.setAttribute(string, namespace2.getURI());
                namespaceStack.push(namespace2);
            }
            for (Attribute attribute : element.getAttributes()) {
                element2.setAttributeNode(this.output(attribute, document));
                object2 = attribute.getNamespace();
                if (object2 != Namespace.NO_NAMESPACE && object2 != Namespace.XML_NAMESPACE) {
                    object = ((Namespace)object2).getPrefix();
                    string = namespaceStack.getURI((String)object);
                    if (!((Namespace)object2).getURI().equals(string)) {
                        String string2 = DOMOutputter.getXmlnsTagFor((Namespace)object2);
                        element2.setAttribute(string2, ((Namespace)object2).getURI());
                        namespaceStack.push((Namespace)object2);
                    }
                }
                if (attribute.getNamespace() == Namespace.NO_NAMESPACE) {
                    element2.setAttribute(attribute.getQualifiedName(), attribute.getValue());
                    continue;
                }
                element2.setAttributeNS(attribute.getNamespaceURI(), attribute.getQualifiedName(), attribute.getValue());
            }
            for (Object object3 : element.getContent()) {
                if (object3 instanceof Element) {
                    object2 = (Element)object3;
                    object = this.output((Element)object2, document, namespaceStack);
                    element2.appendChild((Node)object);
                    continue;
                }
                if (object3 instanceof String) {
                    object2 = (String)object3;
                    object = document.createTextNode((String)object2);
                    element2.appendChild((Node)object);
                    continue;
                }
                if (object3 instanceof CDATA) {
                    object2 = (CDATA)object3;
                    object = document.createCDATASection(((Text)object2).getText());
                    element2.appendChild((Node)object);
                    continue;
                }
                if (object3 instanceof Text) {
                    object2 = (Text)object3;
                    object = document.createTextNode(((Text)object2).getText());
                    element2.appendChild((Node)object);
                    continue;
                }
                if (object3 instanceof Comment) {
                    object2 = (Comment)object3;
                    object = document.createComment(((Comment)object2).getText());
                    element2.appendChild((Node)object);
                    continue;
                }
                if (object3 instanceof ProcessingInstruction) {
                    object2 = (ProcessingInstruction)object3;
                    object = document.createProcessingInstruction(((ProcessingInstruction)object2).getTarget(), ((ProcessingInstruction)object2).getData());
                    element2.appendChild((Node)object);
                    continue;
                }
                if (object3 instanceof EntityRef) {
                    object2 = (EntityRef)object3;
                    object = document.createEntityReference(((EntityRef)object2).getName());
                    element2.appendChild((Node)object);
                    continue;
                }
                throw new JDOMException("Element contained content with type:" + object3.getClass().getName());
            }
            while (namespaceStack.size() > n) {
                namespaceStack.pop();
            }
            return element2;
        }
        catch (Exception exception) {
            throw new JDOMException("Exception outputting Element " + element.getQualifiedName(), exception);
        }
    }

    private Attr output(Attribute attribute, org.w3c.dom.Document document) throws JDOMException {
        Attr attr = null;
        try {
            attr = attribute.getNamespace() == Namespace.NO_NAMESPACE ? document.createAttribute(attribute.getQualifiedName()) : document.createAttributeNS(attribute.getNamespaceURI(), attribute.getQualifiedName());
            attr.setValue(attribute.getValue());
        }
        catch (Exception exception) {
            throw new JDOMException("Exception outputting Attribute " + attribute.getQualifiedName(), exception);
        }
        return attr;
    }

    private static String getXmlnsTagFor(Namespace namespace) {
        Object object = "xmlns";
        if (!namespace.getPrefix().equals("")) {
            object = (String)object + ":";
            object = (String)object + namespace.getPrefix();
        }
        return object;
    }
}

