/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jdom.transform;

import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.DefaultJDOMFactory;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.JDOMFactory;
import com.elixirtech.jdom.input.SAXHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.sax.SAXResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class JDOMResult
extends SAXResult {
    public static final String JDOM_FEATURE = "http://org.jdom.transform.JDOMResult/feature";
    private Object result;
    private boolean queried;
    private JDOMFactory factory;

    public JDOMResult() {
        DocumentBuilder documentBuilder = new DocumentBuilder();
        super.setHandler(documentBuilder);
        super.setLexicalHandler(documentBuilder);
    }

    public void setResult(List list) {
        this.result = list;
        this.queried = false;
    }

    public List<Content> getResult() {
        this.retrieveResult();
        if (this.result instanceof List) {
            this.queried = true;
            return (List)this.result;
        }
        List<Content> list = Collections.emptyList();
        if (this.result instanceof Document && !this.queried) {
            List<Content> list2 = ((Document)this.result).getContent();
            list = new ArrayList<Content>(list2.size());
            while (list2.size() != 0) {
                Content content = list2.remove(0);
                list.add(content);
            }
            this.result = list;
        }
        this.queried = true;
        return list;
    }

    public void setDocument(Document document) {
        this.result = document;
        this.queried = false;
    }

    public Document getDocument() {
        Document document = null;
        this.retrieveResult();
        if (this.result instanceof Document) {
            document = (Document)this.result;
        } else if (this.result instanceof List && !this.queried) {
            try {
                JDOMFactory jDOMFactory = this.getFactory();
                if (jDOMFactory == null) {
                    jDOMFactory = new DefaultJDOMFactory();
                }
                document = jDOMFactory.document(null);
                document.setContent((List)this.result);
                this.result = document;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.queried = true;
        return document;
    }

    public void setFactory(JDOMFactory jDOMFactory) {
        this.factory = jDOMFactory;
    }

    public JDOMFactory getFactory() {
        return this.factory;
    }

    private void retrieveResult() {
        if (this.result == null) {
            this.setResult(((DocumentBuilder)this.getHandler()).getResult());
        }
    }

    @Override
    public void setHandler(ContentHandler contentHandler) {
    }

    @Override
    public void setLexicalHandler(LexicalHandler lexicalHandler) {
    }

    private class DocumentBuilder
    extends XMLFilterImpl
    implements LexicalHandler {
        private FragmentHandler saxHandler;
        private boolean startDocumentReceived;

        public List getResult() {
            List list = null;
            if (this.saxHandler != null) {
                list = this.saxHandler.getResult();
                this.saxHandler = null;
                this.startDocumentReceived = false;
            }
            return list;
        }

        private void ensureInitialization() throws SAXException {
            if (!this.startDocumentReceived) {
                this.startDocument();
            }
        }

        @Override
        public void startDocument() throws SAXException {
            this.startDocumentReceived = true;
            JDOMResult.this.setResult(null);
            this.saxHandler = new FragmentHandler(JDOMResult.this.getFactory());
            super.setContentHandler(this.saxHandler);
            super.startDocument();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.ensureInitialization();
            super.startElement(string, string2, string3, attributes);
        }

        @Override
        public void startPrefixMapping(String string, String string2) throws SAXException {
            this.ensureInitialization();
            super.startPrefixMapping(string, string2);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.ensureInitialization();
            super.characters(cArray, n, n2);
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.ensureInitialization();
            super.ignorableWhitespace(cArray, n, n2);
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
            this.ensureInitialization();
            super.processingInstruction(string, string2);
        }

        @Override
        public void skippedEntity(String string) throws SAXException {
            this.ensureInitialization();
            super.skippedEntity(string);
        }

        @Override
        public void startDTD(String string, String string2, String string3) throws SAXException {
            this.ensureInitialization();
            this.saxHandler.startDTD(string, string2, string3);
        }

        @Override
        public void endDTD() throws SAXException {
            this.saxHandler.endDTD();
        }

        @Override
        public void startEntity(String string) throws SAXException {
            this.ensureInitialization();
            this.saxHandler.startEntity(string);
        }

        @Override
        public void endEntity(String string) throws SAXException {
            this.saxHandler.endEntity(string);
        }

        @Override
        public void startCDATA() throws SAXException {
            this.ensureInitialization();
            this.saxHandler.startCDATA();
        }

        @Override
        public void endCDATA() throws SAXException {
            this.saxHandler.endCDATA();
        }

        @Override
        public void comment(char[] cArray, int n, int n2) throws SAXException {
            this.ensureInitialization();
            this.saxHandler.comment(cArray, n, n2);
        }
    }

    private static class FragmentHandler
    extends SAXHandler {
        private Element dummyRoot = new Element("root", null, null);

        public FragmentHandler(JDOMFactory jDOMFactory) {
            super(jDOMFactory);
            this.pushElement(this.dummyRoot);
        }

        public List getResult() {
            try {
                this.flushCharacters();
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            return this.getDetachedContent(this.dummyRoot);
        }

        private List<Content> getDetachedContent(Element element) {
            List<Content> list = element.getContent();
            ArrayList<Content> arrayList = new ArrayList<Content>(list.size());
            while (list.size() != 0) {
                Content content = list.remove(0);
                arrayList.add(content);
            }
            return arrayList;
        }
    }
}

