/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn;

import com.elixirtech.limn.IndexingPolygon;
import com.elixirtech.limn.PolygonSorter;
import com.elixirtech.limn.RangeD;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class Dependency {
    private IndexingPolygon m_Polygon;
    private Set<IndexingPolygon> m_Dependencies = new HashSet<IndexingPolygon>();

    public static List<IndexingPolygon> orderIgnoreThisCode(List<IndexingPolygon> list) {
        IndexingPolygon[] indexingPolygonArray = new IndexingPolygon[list.size()];
        list.toArray(indexingPolygonArray);
        ArrayList<IndexingPolygon> arrayList = new ArrayList<IndexingPolygon>();
        LinkedList<Dependency> linkedList = new LinkedList<Dependency>();
        HashMap<IndexingPolygon, Dependency> hashMap = new HashMap<IndexingPolygon, Dependency>();
        for (int i = 0; i < indexingPolygonArray.length; ++i) {
            linkedList.add(new Dependency(hashMap, indexingPolygonArray[i], indexingPolygonArray));
        }
        while (linkedList.size() > 0) {
            if (Dependency.extractThoseSatisfied(arrayList, linkedList)) continue;
            Dependency dependency = (Dependency)linkedList.get(0);
            double d = dependency.getZPos();
            for (Dependency dependency2 : linkedList) {
                double d2 = dependency2.getZPos();
                if (!(d2 < d)) continue;
                d = d2;
                dependency = dependency2;
            }
            arrayList.add(dependency.m_Polygon);
            linkedList.remove(dependency);
        }
        return arrayList;
    }

    public static IndexingPolygon getPolygon(IndexingPolygon[] indexingPolygonArray, String string) {
        for (int i = 0; i < indexingPolygonArray.length; ++i) {
            if (!string.equals(indexingPolygonArray[i].toString())) continue;
            return indexingPolygonArray[i];
        }
        return null;
    }

    private static boolean extractThoseSatisfied(List<IndexingPolygon> list, List<Dependency> list2) {
        boolean bl = false;
        ListIterator<Dependency> listIterator = list2.listIterator();
        while (listIterator.hasNext()) {
            Dependency dependency = listIterator.next();
            if (!dependency.isSatisfied(list)) continue;
            listIterator.remove();
            list.add(dependency.m_Polygon);
            bl = true;
        }
        return bl;
    }

    public Dependency(Map<IndexingPolygon, Dependency> map, IndexingPolygon indexingPolygon, IndexingPolygon[] indexingPolygonArray) {
        this.m_Polygon = indexingPolygon;
        map.put(indexingPolygon, this);
        this.buildDependencies(indexingPolygonArray);
    }

    public IndexingPolygon getPolygon() {
        return this.m_Polygon;
    }

    public double getZPos() {
        RangeD[] rangeDArray = this.m_Polygon.getRange();
        return (rangeDArray[2].max + rangeDArray[2].min) / 2.0;
    }

    private void buildDependencies(IndexingPolygon[] indexingPolygonArray) {
        for (int i = 0; i < indexingPolygonArray.length; ++i) {
            int n;
            if (indexingPolygonArray[i] == this.m_Polygon || (n = PolygonSorter.sort(this.m_Polygon, indexingPolygonArray[i])) != 1) continue;
            this.m_Dependencies.add(indexingPolygonArray[i]);
        }
    }

    public boolean isSatisfied(Collection<?> collection) {
        this.m_Dependencies.removeAll(collection);
        return this.m_Dependencies.isEmpty();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_Polygon);
        stringBuffer.append(" depends on [");
        Iterator<IndexingPolygon> iterator = this.m_Dependencies.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

