/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn;

import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.Plane;
import com.elixirtech.limn.Point3d;
import com.elixirtech.limn.Polyhedron;
import com.elixirtech.limn.RangeD;
import com.elixirtech.limn.RenderContext;
import com.elixirtech.limn.RenderedPolygon;
import com.elixirtech.limn.ShadedColor;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.List;

public class IndexingPolygon {
    protected int[] m_Indices;
    protected ShadedColor m_Color;
    protected boolean m_Translucent;
    protected Polyhedron m_Polyhedron;
    protected String m_Id;
    protected long m_Serial;
    private static long m_NextSerial;

    public IndexingPolygon(String string, int[] nArray, ShadedColor shadedColor) {
        this.m_Id = string;
        this.m_Indices = nArray;
        if (shadedColor != null) {
            this.m_Color = shadedColor.makeClone();
        }
        this.m_Translucent = this.m_Color != null && this.m_Color.isTranslucent();
        this.m_Serial = IndexingPolygon.nextSerial();
    }

    public IndexingPolygon(int[] nArray, ShadedColor shadedColor) {
        this.m_Indices = nArray;
        this.m_Color = shadedColor;
        this.m_Translucent = this.m_Color != null && this.m_Color.isTranslucent();
        this.m_Serial = IndexingPolygon.nextSerial();
    }

    public long getSerial() {
        return this.m_Serial;
    }

    public void setPolyhedron(Polyhedron polyhedron) {
        if (this.m_Polyhedron != null) {
            throw new RuntimeException("Polyhedron already set");
        }
        this.m_Polyhedron = polyhedron;
    }

    public Polyhedron getPolyhedron() {
        return this.m_Polyhedron;
    }

    public void buildFaces(List<RenderedPolygon.Face> list) {
    }

    public void getNormal(Point3d point3d) {
        ArrayOf3dPoints arrayOf3dPoints = this.m_Polyhedron.getTransformedVertices();
        int n = this.m_Indices[0];
        int n2 = this.m_Indices[1];
        int n3 = this.m_Indices[this.m_Indices.length - 1];
        Point3d point3d2 = new Point3d(arrayOf3dPoints.x[n], arrayOf3dPoints.y[n], arrayOf3dPoints.z[n]);
        Point3d point3d3 = new Point3d(point3d2, new Point3d(arrayOf3dPoints.x[n2], arrayOf3dPoints.y[n2], arrayOf3dPoints.z[n2]));
        Point3d point3d4 = new Point3d(point3d2, new Point3d(arrayOf3dPoints.x[n3], arrayOf3dPoints.y[n3], arrayOf3dPoints.z[n3]));
        point3d.vectorProduct(point3d3, point3d4);
        point3d.normalize(1.0);
    }

    public RangeD getZRange() {
        ArrayOf3dPoints arrayOf3dPoints = this.m_Polyhedron.getViewPoints();
        RangeD rangeD = new RangeD();
        for (int i = 0; i < this.m_Indices.length; ++i) {
            Point3d point3d = arrayOf3dPoints.getPoint(this.m_Indices[i]);
            rangeD.add(point3d.z);
        }
        return rangeD;
    }

    public RangeD[] getRange() {
        ArrayOf3dPoints arrayOf3dPoints = this.m_Polyhedron.getProjectedPoints();
        RangeD[] rangeDArray = new RangeD[]{new RangeD(), new RangeD(), new RangeD()};
        for (int i = 0; i < this.m_Indices.length; ++i) {
            Point3d point3d = arrayOf3dPoints.getPoint(this.m_Indices[i]);
            rangeDArray[0].add(point3d.x);
            rangeDArray[1].add(point3d.y);
            rangeDArray[2].add(point3d.z);
        }
        return rangeDArray;
    }

    public Plane getPlane() {
        ArrayOf3dPoints arrayOf3dPoints = this.m_Polyhedron.getViewPoints();
        return new Plane(arrayOf3dPoints.getPoint(this.m_Indices[0]), arrayOf3dPoints.getPoint(this.m_Indices[1]), arrayOf3dPoints.getPoint(this.m_Indices[2]));
    }

    public ArrayOf3dPoints getProjectedPoints() {
        ArrayOf3dPoints arrayOf3dPoints = this.m_Polyhedron.getProjectedPoints();
        ArrayOf3dPoints arrayOf3dPoints2 = new ArrayOf3dPoints(this.m_Indices.length);
        for (int i = 0; i < this.m_Indices.length; ++i) {
            arrayOf3dPoints2.x[i] = arrayOf3dPoints.x[this.m_Indices[i]];
            arrayOf3dPoints2.y[i] = arrayOf3dPoints.y[this.m_Indices[i]];
            arrayOf3dPoints2.z[i] = arrayOf3dPoints.z[this.m_Indices[i]];
        }
        return arrayOf3dPoints2;
    }

    public ArrayOf3dPoints getViewPoints() {
        ArrayOf3dPoints arrayOf3dPoints = this.m_Polyhedron.getViewPoints();
        ArrayOf3dPoints arrayOf3dPoints2 = new ArrayOf3dPoints(this.m_Indices.length);
        for (int i = 0; i < this.m_Indices.length; ++i) {
            arrayOf3dPoints2.x[i] = arrayOf3dPoints.x[this.m_Indices[i]];
            arrayOf3dPoints2.y[i] = arrayOf3dPoints.y[this.m_Indices[i]];
            arrayOf3dPoints2.z[i] = arrayOf3dPoints.z[this.m_Indices[i]];
        }
        return arrayOf3dPoints2;
    }

    protected void buildPolygon(Polygon polygon) {
        ArrayOf3dPoints arrayOf3dPoints = this.m_Polyhedron.getProjectedPoints();
        polygon.xpoints = new int[this.m_Indices.length];
        polygon.ypoints = new int[this.m_Indices.length];
        for (int i = 0; i < this.m_Indices.length; ++i) {
            int n = this.m_Indices[i];
            polygon.xpoints[i] = (int)arrayOf3dPoints.x[n];
            polygon.ypoints[i] = (int)arrayOf3dPoints.y[n];
        }
        polygon.npoints = this.m_Indices.length;
    }

    public boolean isTranslucent() {
        return this.m_Translucent;
    }

    public boolean isBackFace() {
        ArrayOf3dPoints arrayOf3dPoints = this.m_Polyhedron.getViewPoints();
        double d = arrayOf3dPoints.x[1];
        double d2 = arrayOf3dPoints.x[2] - d;
        double d3 = arrayOf3dPoints.y[1];
        double d4 = arrayOf3dPoints.y[0] - d3;
        double d5 = arrayOf3dPoints.x[0] - d;
        double d6 = arrayOf3dPoints.y[2] - d3;
        return d2 * d4 - d5 * d6 > 0.0;
    }

    protected static int orientation(Polygon polygon) {
        int n = polygon.xpoints[1];
        int n2 = polygon.ypoints[1];
        int n3 = polygon.xpoints[2] - n;
        int n4 = polygon.ypoints[2] - n2;
        int n5 = polygon.xpoints[0] - n;
        int n6 = polygon.ypoints[0] - n2;
        return n3 * n6 - n5 * n4;
    }

    public void setIntensity(double d) {
        if (this.m_Color != null) {
            this.m_Color.setIntensity(d);
        }
    }

    public void paint(Graphics2D graphics2D, RenderContext renderContext) {
        Polygon polygon = new Polygon(new int[this.m_Indices.length], new int[this.m_Indices.length], this.m_Indices.length);
        this.buildPolygon(polygon);
        if (this.m_Translucent || IndexingPolygon.orientation(polygon) > 0) {
            this.render(graphics2D, renderContext, polygon);
        }
    }

    protected void render(Graphics2D graphics2D, RenderContext renderContext, Polygon polygon) {
        if (this.m_Color != null) {
            graphics2D.setColor(this.m_Color.getColor());
            graphics2D.fillPolygon(polygon);
        }
    }

    public IndexingPolygon makeClone() {
        int[] nArray = new int[this.m_Indices.length];
        System.arraycopy(this.m_Indices, 0, nArray, 0, this.m_Indices.length);
        return new IndexingPolygon(nArray, this.m_Color != null ? this.m_Color.makeClone() : null);
    }

    public void setId(String string) {
        this.m_Id = string;
    }

    public String getId() {
        return this.m_Id;
    }

    public void setShadedColor(ShadedColor shadedColor) {
        this.m_Color = shadedColor.makeClone();
    }

    public ShadedColor getShadedColor() {
        return this.m_Color;
    }

    public int[] getIndices() {
        int[] nArray = new int[this.m_Indices.length];
        System.arraycopy(this.m_Indices, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public String toString() {
        return this.m_Polyhedron.getId() + "." + this.m_Id;
    }

    private static long nextSerial() {
        return ++m_NextSerial;
    }
}

