/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn;

import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.IndexingPolygon;
import com.elixirtech.limn.RenderContext;
import com.elixirtech.limn.ShadedColor;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class RenderedPolygon
extends IndexingPolygon {
    private Face m_Face;

    public RenderedPolygon(String string, int[] nArray, ShadedColor shadedColor) {
        super(string, nArray, shadedColor);
    }

    public RenderedPolygon(int[] nArray, ShadedColor shadedColor) {
        super(nArray, shadedColor);
    }

    @Override
    public IndexingPolygon makeClone() {
        int[] nArray = new int[this.m_Indices.length];
        System.arraycopy(this.m_Indices, 0, nArray, 0, this.m_Indices.length);
        return new RenderedPolygon(nArray, this.m_Color != null ? this.m_Color.makeClone() : null);
    }

    public void setFace(Face face) {
        this.m_Face = face;
    }

    public Face getFace() {
        return this.m_Face;
    }

    @Override
    public void buildFaces(List<Face> list) {
        if (this.m_Face != null) {
            list.add(this.m_Face);
        }
    }

    @Override
    protected void render(Graphics2D graphics2D, RenderContext renderContext, Polygon polygon) {
        if (this.m_Color != null) {
            graphics2D.setColor(this.m_Color.getColor());
            graphics2D.fillPolygon(polygon);
            graphics2D.setColor(this.m_Color.getColor().darker());
            int n = polygon.npoints - 1;
            for (int i = 0; i < n; ++i) {
                graphics2D.drawLine(polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[i + 1], polygon.ypoints[i + 1]);
            }
            graphics2D.drawLine(polygon.xpoints[n], polygon.ypoints[n], polygon.xpoints[0], polygon.ypoints[0]);
        }
        if (this.m_Face != null) {
            this.m_Face.render(graphics2D, renderContext, this, polygon);
        }
    }

    public static interface Face {
        public void render(Graphics2D var1, RenderContext var2, RenderedPolygon var3, Polygon var4);

        public Rectangle2D getBoundingBox(RenderContext var1, ArrayOf3dPoints var2);
    }
}

