/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class Label {
    private String m_Text;
    private Point m_Point;
    private int m_Align;
    private int m_Orientation;
    private Color m_Color;
    private Font m_Font;

    public Label(String string, Point point, int n, int n2, Color color, Font font) {
        this.m_Text = string;
        this.m_Point = point;
        this.m_Align = n;
        this.m_Orientation = n2;
        this.m_Color = color;
        this.m_Font = font;
    }

    public void offsetX(int n) {
        this.m_Point.x += n;
    }

    public void offsetY(int n) {
        this.m_Point.y += n;
    }

    public void draw(Graphics2D graphics2D) {
        graphics2D.setFont(this.m_Font);
        graphics2D.setColor(this.m_Color);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.stringWidth(this.m_Text);
        int n2 = fontMetrics.getAscent();
        graphics2D.translate(this.m_Point.x, this.m_Point.y);
        if (this.m_Orientation == 5) {
            graphics2D.rotate(1.5707963267948966);
        } else if (this.m_Orientation == 6) {
            graphics2D.rotate(-1.5707963267948966);
        }
        if (this.m_Align == 3) {
            graphics2D.drawString(this.m_Text, -n, n2 / 2);
        } else if (this.m_Align == 2) {
            graphics2D.drawString(this.m_Text, -n / 2, n2 / 2);
        } else {
            graphics2D.drawString(this.m_Text, 0, n2 / 2);
        }
        if (this.m_Orientation == 5) {
            graphics2D.rotate(-1.5707963267948966);
        } else if (this.m_Orientation == 6) {
            graphics2D.rotate(1.5707963267948966);
        }
        graphics2D.translate(-this.m_Point.x, -this.m_Point.y);
    }

    public Rectangle2D getBoundingBox(FontRenderContext fontRenderContext) {
        TextLayout textLayout = new TextLayout(this.m_Text, this.m_Font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        float f = textLayout.getAscent();
        float f2 = (float)rectangle2D.getY() + f / 2.0f;
        Rectangle2D rectangle2D2 = null;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.m_Point.x, this.m_Point.y);
        if (this.m_Orientation == 5) {
            affineTransform.rotate(1.5707963267948966);
        } else if (this.m_Orientation == 6) {
            affineTransform.rotate(-1.5707963267948966);
        }
        rectangle2D2 = this.m_Align == 3 ? new Rectangle2D.Double(-rectangle2D.getWidth(), f2, rectangle2D.getWidth(), rectangle2D.getHeight()) : (this.m_Align == 2 ? new Rectangle2D.Double(-rectangle2D.getWidth() / 2.0, f2, rectangle2D.getWidth(), rectangle2D.getHeight()) : new Rectangle2D.Double(0.0, f2, rectangle2D.getWidth(), rectangle2D.getHeight()));
        rectangle2D2 = affineTransform.createTransformedShape(rectangle2D2).getBounds2D();
        return this.grow(rectangle2D2, 3.0);
    }

    private Rectangle2D grow(Rectangle2D rectangle2D, double d) {
        if (rectangle2D == null) {
            return null;
        }
        return new Rectangle2D.Double(rectangle2D.getX() - d, rectangle2D.getY() - d, rectangle2D.getWidth() + 2.0 * d, rectangle2D.getHeight() + 2.0 * d);
    }
}

