/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn.chart.values;

import com.elixirtech.limn.Angle3d;
import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.IndexingPolygon;
import com.elixirtech.limn.Object3d;
import com.elixirtech.limn.Point3d;
import com.elixirtech.limn.Polyhedron;
import com.elixirtech.limn.RenderedPolygon;
import com.elixirtech.limn.ShadedColor;
import com.elixirtech.limn.World;

public class SurfaceValues
extends Object3d {
    public SurfaceValues(String string, World world, Point3d point3d, Angle3d angle3d, ShadedColor shadedColor) {
        super(world, point3d, angle3d);
        double[] dArray = new double[10];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 10.0 + Math.random() * 80.0;
        }
        Polyhedron polyhedron = SurfaceValues.renderedValue(dArray, 20, 20, shadedColor);
        polyhedron.setId(string);
        this.setPolyhedron(polyhedron, new Point3d(1.0, 1.0, 1.0));
    }

    public static Polyhedron renderedValue(double[] dArray, int n, int n2, ShadedColor shadedColor) {
        int n3;
        int n4 = dArray.length * 4;
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        double[] dArray4 = new double[n4];
        int n5 = 0;
        double d = (double)n / 2.0;
        for (int i = 0; i < dArray.length; ++i) {
            n3 = i * 4;
            dArray2[n3] = n5;
            dArray2[n3 + 1] = n5;
            dArray2[n3 + 2] = n5;
            dArray2[n3 + 3] = n5;
            n5 += n2;
            dArray3[n3] = 0.0;
            dArray3[n3 + 1] = dArray[i];
            dArray3[n3 + 2] = dArray[i];
            dArray3[n3 + 3] = 0.0;
            dArray4[n3] = d;
            dArray4[n3 + 1] = d;
            dArray4[n3 + 2] = -d;
            dArray4[n3 + 3] = -d;
        }
        ArrayOf3dPoints arrayOf3dPoints = new ArrayOf3dPoints(dArray2, dArray3, dArray4, n4);
        n3 = n4 - 2;
        IndexingPolygon[] indexingPolygonArray = new IndexingPolygon[n3];
        for (int i = 0; i < dArray.length - 1; ++i) {
            int n6 = i * 4;
            indexingPolygonArray[n6] = new RenderedPolygon(n6 + "-0", new int[]{n6, n6 + 1, n6 + 5, n6 + 4}, shadedColor);
            indexingPolygonArray[n6 + 1] = new RenderedPolygon(n6 + "-1", new int[]{n6 + 1, n6 + 2, n6 + 6, n6 + 5}, shadedColor);
            indexingPolygonArray[n6 + 2] = new RenderedPolygon(n6 + "-2", new int[]{n6 + 2, n6 + 3, n6 + 7, n6 + 6}, shadedColor);
            indexingPolygonArray[n6 + 3] = new RenderedPolygon(n6 + "-3", new int[]{n6 + 3, n6, n6 + 4, n6 + 7}, shadedColor);
        }
        indexingPolygonArray[n3 - 2] = new RenderedPolygon("start", new int[]{0, 3, 2, 1}, shadedColor);
        indexingPolygonArray[n3 - 1] = new RenderedPolygon("end", new int[]{n4 - 1, n4 - 4, n4 - 3, n4 - 2}, shadedColor);
        Polyhedron polyhedron = new Polyhedron(arrayOf3dPoints, indexingPolygonArray);
        return polyhedron;
    }
}

