/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.basic;

import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.map.IShapes;
import com.elixirtech.map.basic.BasicShape;
import com.elixirtech.map.basic.BasicShapes;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BasicShapeLoader {
    private DataSchema m_Schema;
    private BasicShapes m_Shapes;
    private final List<Point2D> m_Points = new ArrayList<Point2D>();
    private boolean m_ExpectingFirstLine;
    private String m_Id;
    private String m_Field;
    private int m_LineNo;
    private final List<DataRecord> m_Records = new ArrayList<DataRecord>();

    public IShapes loadShapes(InputStream inputStream) throws IOException {
        Object object;
        SchemaBuilder schemaBuilder = new SchemaBuilder(true);
        schemaBuilder.add("Id", DataType.STRING, new DataAttributes());
        schemaBuilder.add("Field", DataType.STRING, new DataAttributes());
        this.m_Schema = schemaBuilder.getSchema();
        this.m_Records.clear();
        this.m_Shapes = new BasicShapes();
        this.initShape();
        this.m_LineNo = 0;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        while ((object = bufferedReader.readLine()) != null) {
            ++this.m_LineNo;
            if (((String)(object = ((String)object).trim())).length() == 0) {
                this.initShape();
                continue;
            }
            this.processLine((String)object);
        }
        this.addShape();
        object = new DataRecord[this.m_Records.size()];
        this.m_Records.toArray((T[])object);
        DataTable dataTable = new DataTable("Basic", this.m_Schema, (DataRecord[])object);
        this.m_Shapes.setRecords(dataTable);
        return this.m_Shapes;
    }

    private void initShape() {
        if (this.m_Points.size() > 0) {
            this.addShape();
        }
        this.m_ExpectingFirstLine = true;
        this.m_Id = null;
        this.m_Field = null;
        this.m_Points.clear();
    }

    private void processLine(String string) throws IOException {
        String[] stringArray = string.split("\t");
        if (stringArray.length >= 2) {
            if (this.m_ExpectingFirstLine) {
                this.m_Id = stringArray[0];
                this.m_Field = stringArray[1];
                this.m_ExpectingFirstLine = false;
            } else {
                float f = Float.parseFloat(stringArray[0]);
                float f2 = Float.parseFloat(stringArray[1]);
                this.m_Points.add(new Point2D.Float(f, f2));
            }
        } else {
            throw new IOException("Syntax error on line " + this.m_LineNo + ": " + string);
        }
    }

    private void addShape() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Field", this.m_Field);
        int n = this.m_Points.size();
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            Point2D point2D = this.m_Points.get(i);
            fArray[i] = (float)point2D.getX();
            fArray2[i] = (float)point2D.getY();
        }
        this.m_Shapes.add(new BasicShape(this.m_Id, hashMap, fArray, fArray2));
        Object[] objectArray = new Object[]{this.m_Id, this.m_Field};
        this.m_Records.add(new DataRecord(this.m_Schema, objectArray));
    }
}

