/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.coloring;

import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.map.coloring.PositionBasedColoringAlgorithm;
import com.elixirtech.util.FileUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ImageColoringAlgorithm
extends PositionBasedColoringAlgorithm {
    private BufferedImage m_Image;
    private int m_Width;

    @Override
    public void setConfig(String string) throws RuntimeException {
        InputStream inputStream = null;
        try {
            inputStream = URLLoader.getInputStream(string);
            this.m_Image = ImageIO.read(inputStream);
            this.m_Width = this.m_Image.getWidth();
        }
        catch (IOException iOException) {
            try {
                throw new RuntimeException("Error reading image: " + iOException, iOException);
            }
            catch (Throwable throwable) {
                FileUtil.close(inputStream);
                throw throwable;
            }
        }
        FileUtil.close(inputStream);
    }

    @Override
    public Color getColor(float f) {
        int n = (int)(f * (float)(this.m_Width - 1));
        return new Color(this.m_Image.getRGB(n, 0));
    }

    @Override
    public void fillContinuousRange(Graphics2D graphics2D, Rectangle rectangle, boolean bl, boolean bl2) {
        graphics2D.translate(rectangle.x, rectangle.y);
        if (bl) {
            graphics2D.rotate(1.5707963267948966);
            graphics2D.translate(0, -rectangle.width);
            if (bl2) {
                graphics2D.drawImage(this.m_Image, 0, 0, rectangle.height, rectangle.width, 0, 0, this.m_Width, 1, null);
            } else {
                graphics2D.drawImage(this.m_Image, 0, 0, rectangle.height, rectangle.width, this.m_Width, 0, 0, 1, null);
            }
            graphics2D.translate(0, rectangle.width);
            graphics2D.rotate(-1.5707963267948966);
        } else if (bl2) {
            graphics2D.drawImage(this.m_Image, 0, 0, rectangle.width, rectangle.height, 0, 0, this.m_Width, 1, null);
        } else {
            graphics2D.drawImage(this.m_Image, 0, 0, rectangle.width, rectangle.height, this.m_Width, 0, 0, 1, null);
        }
        graphics2D.translate(-rectangle.x, -rectangle.y);
    }
}

