/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.coloring;

import com.elixirtech.map.FillData;
import com.elixirtech.map.coloring.IColoringAlgorithm;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;

public class LookupColoringAlgorithm
implements IColoringAlgorithm {
    private final Map<Object, Color> m_Map = new HashMap<Object, Color>();

    @Override
    public void setConfig(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("\\|")) {
            int n = string2.indexOf(61);
            if (n < 0) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            if (string3.length() <= 0 || string4.length() <= 0) continue;
            this.m_Map.put(string3, StandardColor.lookup(string4));
        }
        if (this.m_Map.isEmpty()) {
            throw new IllegalArgumentException("No colours defined: " + string);
        }
    }

    @Override
    public void setData(FillData fillData) {
        for (FillData.Item item : fillData.getItems()) {
            item.color = this.m_Map.get(item.value);
        }
    }

    @Override
    public boolean supportsContinuousRange() {
        return false;
    }

    @Override
    public void fillContinuousRange(Graphics2D graphics2D, Rectangle rectangle, boolean bl, boolean bl2) {
        throw new UnsupportedOperationException("fillContinuousRange");
    }
}

