/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.shapefile;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.map.IShape;
import com.elixirtech.map.IShapes;
import com.elixirtech.map.shapefile.SHPNull;
import com.elixirtech.map.shapefile.SHPPoint;
import com.elixirtech.map.shapefile.SHPPolygon;
import com.elixirtech.map.shapefile.SHPPolyline;
import com.elixirtech.map.shapefile.SHPShape;
import com.elixirtech.map.shapefile.SHPShapes;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFReader;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class ShapeFileLoader {
    private SHPShapes m_Shapes;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ShapeFileLoader.class);

    public IShapes loadShapes(InputStream inputStream) throws IOException {
        Rectangle2D rectangle2D = ShapeFileLoader.readHeader(inputStream);
        if (rectangle2D != null) {
            SHPShape sHPShape;
            this.m_Shapes = new SHPShapes(rectangle2D);
            while ((sHPShape = ShapeFileLoader.readShapeRecord(inputStream)) != null) {
                this.m_Shapes.addShape(sHPShape);
            }
        }
        return this.m_Shapes;
    }

    public IShapes loadShapesAndData(InputStream inputStream, InputStream inputStream2) throws IOException {
        Rectangle2D rectangle2D = ShapeFileLoader.readHeader(inputStream);
        if (rectangle2D != null) {
            SHPShape sHPShape;
            this.m_Shapes = new SHPShapes(rectangle2D);
            while ((sHPShape = ShapeFileLoader.readShapeRecord(inputStream)) != null) {
                this.m_Shapes.addShape(sHPShape);
            }
            this.readData(inputStream2);
        }
        return this.m_Shapes;
    }

    public IShapes loadData(InputStream inputStream) throws IOException {
        if (this.m_Shapes == null) {
            throw new IllegalStateException("loadShapes must be called before loadData");
        }
        this.readData(inputStream);
        return this.m_Shapes;
    }

    protected static Rectangle2D readHeader(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[100];
        int n = ShapeFileLoader.readAsMuchAsPossible(inputStream, byArray);
        if (n == 0) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n2 = ShapeFileLoader.readIntBE(byteArrayInputStream, "file code");
        if (n2 != 9994) {
            throw new IOException("Invalid file code: not an ESRI shapefile");
        }
        byteArrayInputStream.skip(20L);
        ShapeFileLoader.readIntBE(byteArrayInputStream, "file length");
        int n3 = ShapeFileLoader.readIntLE(byteArrayInputStream, "version");
        assert (n3 == 1000);
        ShapeFileLoader.readIntLE(byteArrayInputStream, "shape type");
        double d = ShapeFileLoader.readDoubleLE(byteArrayInputStream, "x min");
        double d2 = ShapeFileLoader.readDoubleLE(byteArrayInputStream, "y min");
        double d3 = ShapeFileLoader.readDoubleLE(byteArrayInputStream, "x max");
        double d4 = ShapeFileLoader.readDoubleLE(byteArrayInputStream, "y max");
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        return double_;
    }

    protected static SHPShape readShapeRecord(InputStream inputStream) throws IOException {
        int n = 0;
        try {
            n = ShapeFileLoader.readIntBE(inputStream, "record no");
        }
        catch (EOFException eOFException) {
            return null;
        }
        int n2 = ShapeFileLoader.readIntBE(inputStream, "content len") * 2;
        byte[] byArray = new byte[n2];
        ShapeFileLoader.readFully(inputStream, byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n3 = ShapeFileLoader.readIntLE(byteArrayInputStream, "record type");
        switch (n3) {
            case 0: {
                return SHPNull.NULL;
            }
            case 1: {
                return ShapeFileLoader.readPoint(byteArrayInputStream, n);
            }
            case 3: {
                return ShapeFileLoader.readPolyline(byteArrayInputStream, n);
            }
            case 5: {
                return ShapeFileLoader.readPolygon(byteArrayInputStream, n);
            }
        }
        return SHPNull.NULL;
    }

    protected static SHPShape readPoint(InputStream inputStream, int n) throws IOException {
        Point2D.Double double_ = new Point2D.Double(ShapeFileLoader.readDoubleLE(inputStream, "x"), ShapeFileLoader.readDoubleLE(inputStream, "y"));
        SHPPoint sHPPoint = new SHPPoint(String.valueOf(n), double_);
        return sHPPoint;
    }

    protected static SHPShape readPolyline(InputStream inputStream, int n) throws IOException {
        int n2;
        double d = ShapeFileLoader.readDoubleLE(inputStream, null);
        double d2 = ShapeFileLoader.readDoubleLE(inputStream, null);
        double d3 = ShapeFileLoader.readDoubleLE(inputStream, null);
        double d4 = ShapeFileLoader.readDoubleLE(inputStream, null);
        int n3 = ShapeFileLoader.readIntLE(inputStream, "num parts");
        int n4 = ShapeFileLoader.readIntLE(inputStream, "num points");
        int[] nArray = new int[n3];
        Point2D[] point2DArray = new Point2D[n4];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = ShapeFileLoader.readIntLE(inputStream, null);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            point2DArray[n2] = new Point2D.Double(ShapeFileLoader.readDoubleLE(inputStream, "x"), ShapeFileLoader.readDoubleLE(inputStream, "y"));
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        SHPPolyline sHPPolyline = new SHPPolyline(String.valueOf(n), double_, nArray, point2DArray);
        return sHPPolyline;
    }

    protected static SHPShape readPolygon(InputStream inputStream, int n) throws IOException {
        int n2;
        double d = ShapeFileLoader.readDoubleLE(inputStream, null);
        double d2 = ShapeFileLoader.readDoubleLE(inputStream, null);
        double d3 = ShapeFileLoader.readDoubleLE(inputStream, null);
        double d4 = ShapeFileLoader.readDoubleLE(inputStream, null);
        int n3 = ShapeFileLoader.readIntLE(inputStream, "num parts");
        int n4 = ShapeFileLoader.readIntLE(inputStream, "num points");
        int[] nArray = new int[n3];
        Point2D[] point2DArray = new Point2D[n4];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = ShapeFileLoader.readIntLE(inputStream, null);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            point2DArray[n2] = new Point2D.Double(ShapeFileLoader.readDoubleLE(inputStream, null), ShapeFileLoader.readDoubleLE(inputStream, null));
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        SHPPolygon sHPPolygon = new SHPPolygon(String.valueOf(n), double_, nArray, point2DArray);
        return sHPPolygon;
    }

    private void readData(InputStream inputStream) throws IOException {
        DBFReader dBFReader = new DBFReader(inputStream);
        int n = dBFReader.getFieldCount();
        DBFField[] dBFFieldArray = new DBFField[n];
        SchemaBuilder schemaBuilder = new SchemaBuilder(true);
        for (int i = 0; i < n; ++i) {
            dBFFieldArray[i] = dBFReader.getField(i);
            schemaBuilder.add(dBFFieldArray[i].getName(), ShapeFileLoader.getDataType(dBFFieldArray[i].getDataType()), new DataAttributes());
        }
        DataSchema dataSchema = schemaBuilder.getSchema();
        List<? extends IShape> list = this.m_Shapes.getShapes();
        int n2 = dBFReader.getRecordCount();
        if (n2 > list.size()) {
            m_Log.warn((Object)("DBF contains " + n2 + " records, whereas SHP only has " + list.size() + " shapes"));
            n2 = list.size();
        }
        DataRecord[] dataRecordArray = new DataRecord[n2];
        for (int i = 0; i < n2; ++i) {
            try {
                int n3;
                SHPShape sHPShape = (SHPShape)list.get(i);
                Object[] objectArray = dBFReader.nextRecord();
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    if (2 != dataSchema.getColumnType(n3).getTypeId()) continue;
                    objectArray[n3] = ((String)objectArray[n3]).trim();
                }
                dataRecordArray[i] = new DataRecord(dataSchema, objectArray);
                for (n3 = 0; n3 < n; ++n3) {
                    sHPShape.addAttribute(dBFFieldArray[n3].getName(), String.valueOf(objectArray[n3]).trim());
                }
                continue;
            }
            catch (Throwable throwable) {
                m_Log.warn((Object)("Error reading dbf record " + i), throwable);
            }
        }
        DataTable dataTable = new DataTable("DBF", dataSchema, dataRecordArray);
        this.m_Shapes.setRecords(dataTable);
    }

    protected static DataType getDataType(byte by) {
        switch (by) {
            case 67: {
                return DataType.STRING;
            }
            case 68: {
                return DataType.DATE;
            }
            case 70: {
                return DataType.DOUBLE;
            }
            case 76: {
                return DataType.BOOLEAN;
            }
            case 77: {
                return DataType.STRING;
            }
            case 78: {
                return DataType.DOUBLE;
            }
        }
        return DataType.UNKNOWN;
    }

    private static int readIntBE(InputStream inputStream, String string) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        int n5 = (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
        return n5;
    }

    private static int readIntLE(InputStream inputStream, String string) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        int n5 = (n << 24) + (n2 << 16) + (n3 << 8) + n4;
        return n5;
    }

    private static long readLongLE(InputStream inputStream, String string) throws IOException {
        long l = ShapeFileLoader.readIntLE(inputStream, null);
        long l2 = ShapeFileLoader.readIntLE(inputStream, null);
        long l3 = (l2 << 32) + l;
        return l3;
    }

    private static double readDoubleLE(InputStream inputStream, String string) throws IOException {
        return Double.longBitsToDouble(ShapeFileLoader.readLongLE(inputStream, null));
    }

    public static final void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            n = inputStream.read(byArray, i, byArray.length - i);
            if (n >= 0) continue;
            throw new EOFException();
        }
    }

    public static final int readAsMuchAsPossible(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2;
        for (n = 0; n < byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) >= 0; n += n2) {
        }
        return n;
    }
}

