/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.view;

import com.elixirtech.map.view.IView;
import com.elixirtech.map.view.ViewUtil;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;

public abstract class AbstractView
implements IView {
    protected Rectangle m_Rect;

    protected abstract String getLocation();

    protected abstract Dimension getViewSize(Rectangle var1);

    @Override
    public Rectangle doLayout(Rectangle rectangle) {
        this.m_Rect = null;
        String string = this.getLocation();
        if ("None".equals(string)) {
            return rectangle;
        }
        Insets insets = new Insets(0, 0, 0, 0);
        Dimension dimension = this.getViewSize(rectangle);
        if ("North".equals(string)) {
            this.m_Rect = new Rectangle(rectangle.x, rectangle.y, rectangle.width, dimension.height);
            insets.top += dimension.height + 10;
        } else if ("South".equals(string)) {
            int n = rectangle.y + rectangle.height - dimension.height;
            this.m_Rect = new Rectangle(rectangle.x, n, rectangle.width, dimension.height);
            insets.bottom += dimension.height + 10;
        } else if ("West".equals(string)) {
            this.m_Rect = new Rectangle(rectangle.x, rectangle.y, dimension.width, rectangle.height);
            insets.left += dimension.width + 10;
        } else if ("East".equals(string)) {
            int n = rectangle.x + rectangle.width - dimension.width;
            this.m_Rect = new Rectangle(n, rectangle.y, dimension.width, rectangle.height);
            insets.right += dimension.width + 10;
        }
        return ViewUtil.inset(rectangle, insets);
    }

    protected int getLength(Rectangle rectangle) {
        String string = this.getLocation();
        if ("North".equals(string) || "South".equals(string)) {
            return rectangle.width;
        }
        return rectangle.height;
    }

    protected boolean isHorizontal() {
        String string = this.getLocation();
        return "North".equals(string) || "South".equals(string);
    }
}

