/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.view;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.graphics.TextAlignment;
import com.elixirtech.graphics.text.TextBuilder;
import com.elixirtech.map.model.Font;
import com.elixirtech.map.model.Title;
import com.elixirtech.map.view.AbstractView;
import com.elixirtech.ui.StandardColor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.text.AttributedString;

public class TitleView
extends AbstractView {
    private Title m_Title;
    private ArgumentMap.ICallback m_Callback;
    private TextBuilder m_TextBuilder = new TextBuilder();

    public TitleView() {
        this.m_TextBuilder.setAlignment(TextAlignment.CENTER);
        this.m_TextBuilder.setCanGrow(true);
    }

    public void setTitle(Title title) {
        this.m_Title = title;
    }

    public void setSubstitution(ArgumentMap.ICallback iCallback) {
        this.m_Callback = iCallback;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.m_Rect == null) {
            return;
        }
        if (this.isHorizontal()) {
            this.m_TextBuilder.render(graphics2D, this.m_Rect.x, this.m_Rect.y, 0, false);
        } else {
            graphics2D.translate(this.m_Rect.x, this.m_Rect.y);
            graphics2D.translate(0, this.m_Rect.height);
            graphics2D.rotate(-1.5707963267948966);
            this.m_TextBuilder.render(graphics2D, 0.0f, 0.0f, 0, false);
            graphics2D.rotate(1.5707963267948966);
            graphics2D.translate(0, -this.m_Rect.height);
            graphics2D.translate(-this.m_Rect.x, -this.m_Rect.y);
        }
    }

    @Override
    protected String getLocation() {
        return this.m_Title.getLocation();
    }

    @Override
    protected Dimension getViewSize(Rectangle rectangle) {
        String string = this.substitute(this.m_Title.getText());
        if (StringUtil.isEmpty(string)) {
            this.m_TextBuilder.setText(null);
            return new Dimension(0, 0);
        }
        Font font = this.m_Title.getFont();
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(TextAttribute.FONT, font.getAWTFont());
        attributedString.addAttribute(TextAttribute.FOREGROUND, StandardColor.lookup(font.getColor()));
        this.m_TextBuilder.setText(attributedString);
        boolean bl = this.isHorizontal();
        if (bl) {
            this.m_TextBuilder.setDimension(rectangle.width, 2.1474836E9f);
        } else {
            this.m_TextBuilder.setDimension(rectangle.height, 2.1474836E9f);
        }
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        this.m_TextBuilder.buildLayouts(fontRenderContext, 0);
        if (bl) {
            return new Dimension(rectangle.width, (int)Math.ceil(this.m_TextBuilder.getActualHeight()));
        }
        return new Dimension((int)Math.ceil(this.m_TextBuilder.getActualHeight()), rectangle.height);
    }

    private String substitute(String string) {
        if (this.m_Callback != null) {
            return ArgumentMap.substitute(string, this.m_Callback);
        }
        return string;
    }
}

