/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc;

import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.Namespace;
import com.elixirtech.opc.Package;
import com.elixirtech.opc.Part;
import com.elixirtech.opc.XMLPart;
import java.util.HashMap;
import java.util.Map;

public class ContentTypes
extends XMLPart {
    public static final String PART_NAME = "/[Content_Types].xml";
    public static final String XMLNS = "http://schemas.openxmlformats.org/package/2006/content-types";
    public static final Namespace NS = Namespace.getNamespace("http://schemas.openxmlformats.org/package/2006/content-types");
    private static final Map<String, String> DEFAULTS = new HashMap<String, String>();

    public ContentTypes(Package package_) {
        super(PART_NAME, "text/xml");
        this.setDocument(ContentTypes.buildDocument(package_));
    }

    public ContentTypes(Document document) {
        super(PART_NAME, "text/xml");
        this.setDocument(document);
    }

    public String getContentType(String string) {
        String string2;
        Element element = this.m_Document.getRootElement();
        for (Element element2 : element.getChildren("Override", NS)) {
            string2 = element2.getAttributeValue("PartName");
            if (!string.equals(string2)) continue;
            return element2.getAttributeValue("ContentType");
        }
        for (Element element2 : element.getChildren("Default", NS)) {
            string2 = element2.getAttributeValue("Extension");
            if (!string.endsWith(string2)) continue;
            return element2.getAttributeValue("ContentType");
        }
        return "application/octet-stream";
    }

    public static final Document buildDocument(Package package_) {
        Object object;
        Element element = new Element("Types", NS);
        for (Map.Entry<String, String> object2 : DEFAULTS.entrySet()) {
            object = new Element("Default", NS);
            ((Element)object).setAttribute("Extension", object2.getKey());
            ((Element)object).setAttribute("ContentType", object2.getValue());
            element.addContent((Content)object);
        }
        for (Part part : package_.getParts()) {
            object = part.getName();
            if (!ContentTypes.includeOverride((String)object)) continue;
            Element element2 = new Element("Override", NS);
            element2.setAttribute("PartName", (String)object);
            element2.setAttribute("ContentType", part.getContentType());
            element.addContent(element2);
        }
        return new Document(element);
    }

    private static boolean includeOverride(String string) {
        return !string.endsWith(".rels") && !string.equals(PART_NAME);
    }

    static {
        DEFAULTS.put("rels", "application/vnd.openxmlformats-package.relationships+xml");
        DEFAULTS.put("xml", "application/xml");
        DEFAULTS.put("png", "image/png");
        DEFAULTS.put("wmf", "image/x-wmf");
    }
}

