/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc;

import com.elixirtech.opc.Relationship;
import com.elixirtech.opc.RelationshipsPart;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class Part {
    private final String m_Name;
    private final String m_ContentType;
    protected RelationshipsPart m_Relationships;

    public Part(String string, String string2) {
        assert (string != null);
        String string3 = string.trim();
        this.validateName(string3);
        this.m_Name = string3;
        this.m_ContentType = string2;
    }

    public String getName() {
        return this.m_Name;
    }

    public String getContentType() {
        return this.m_ContentType;
    }

    public void setRelationships(RelationshipsPart relationshipsPart) {
        this.m_Relationships = relationshipsPart;
    }

    public String addRelationship(Relationship relationship) {
        if (this.m_Relationships == null) {
            this.initRelationships();
        }
        return this.m_Relationships.addRelationship(relationship);
    }

    public RelationshipsPart getRelationships() {
        return this.m_Relationships;
    }

    public abstract void write(OutputStream var1) throws IOException;

    public String toString() {
        return this.m_Name + " [" + this.m_ContentType + "]";
    }

    protected void initRelationships() {
        this.m_Relationships = new RelationshipsPart(this.relsName());
    }

    private String relsName() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(Arrays.asList(this.m_Name.substring(1).split("/")));
        int n = arrayList.size();
        arrayList.add(n - 1, "_rels");
        String string = (String)arrayList.get(n);
        arrayList.set(n, string + ".rels");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : arrayList) {
            stringBuilder.append('/');
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private void validateName(String string) {
        assert (string.length() > 0);
        assert (string.startsWith("/"));
        assert (!string.endsWith("/"));
        assert (!string.contains("%2F"));
        assert (!string.contains("%5C"));
        String[] stringArray = string.split("/");
        for (int i = 1; i < stringArray.length; ++i) {
            assert (stringArray[i].length() > 0);
            assert (!stringArray[i].endsWith("."));
        }
    }
}

