/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.xls;

import com.elixirtech.jdom.Element;
import com.elixirtech.opc.BinaryPart;
import com.elixirtech.opc.Build;
import com.elixirtech.opc.Part;
import com.elixirtech.opc.Relationship;
import com.elixirtech.opc.util.XMLUtil;
import com.elixirtech.opc.xls.CellUtil;
import com.elixirtech.opc.xls.Col;
import com.elixirtech.opc.xls.Drawing;
import com.elixirtech.opc.xls.ExtendedXMLPart;
import com.elixirtech.opc.xls.IDGenerator;
import com.elixirtech.opc.xls.Location;
import com.elixirtech.opc.xls.Row;
import com.elixirtech.opc.xls.TwoCellAnchor;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;

public class Sheet
extends ExtendedXMLPart {
    public static final long IMAGE_DPI = 96L;
    public static final String CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml";
    private static final String SHEET = "com/elixirtech/opc/xls/parts/worksheet/sheet1.xml";
    private IDGenerator m_IDGenerator;
    private List<Col> m_ColList = new ArrayList<Col>();
    private Drawing m_Drawing;
    private Element m_Cols;
    private Element m_MergeCells;
    private Element m_SheetData;
    private Element m_Dimension;
    private final List<Part> m_SubParts = new ArrayList<Part>();
    private final List<Row> m_Rows = new ArrayList<Row>();
    private final BitSet m_RowBitSet = new BitSet();
    private final BitSet m_ColBitSet = new BitSet();
    private String m_Title;
    private Location m_TopLeft = new Location(0, 0);
    private Location m_BottomRight = new Location(0, 0);

    public Sheet(IDGenerator iDGenerator, String string, String string2) throws IOException {
        super(string, CONTENT_TYPE);
        this.m_IDGenerator = iDGenerator;
        this.m_Title = Sheet.normalizeName(string2);
        this.setDocument(XMLUtil.loadResource(SHEET));
        this.buildExtensionPoints();
    }

    public void fixTitle(Set<String> set) {
        String string = this.m_Title;
        int n = 1;
        String string2 = Sheet.numberedTitle(string, n);
        while (set.contains(string2)) {
            string2 = Sheet.numberedTitle(string, ++n);
        }
        this.m_Title = string2;
    }

    public void setTabColor(Color color) throws IOException {
        Element element = this.m_Document.getRootElement();
        Element element2 = Sheet.getElement(element, "/s:worksheet/s:sheetPr/s:tabColor");
        element2.removeAttribute("auto");
        element2.setAttribute("rgb", CellUtil.ARGB(color));
    }

    public String getTitle() {
        return this.m_Title;
    }

    public void addRow(Row row) {
        assert (!row.isEmpty());
        int n = row.getIndex();
        if (this.m_RowBitSet.get(n)) {
            throw new IllegalStateException("Already a row " + n);
        }
        this.m_RowBitSet.set(n);
        this.m_Rows.add(row);
        Collections.sort(this.m_Rows);
        int n2 = Collections.binarySearch(this.m_Rows, row);
        this.m_SheetData.addContent(n2, row.getElement());
        this.m_TopLeft = Location.min(this.m_TopLeft, row.getFirstLocation());
        this.m_BottomRight = Location.max(this.m_BottomRight, row.getLastLocation());
        if (this.m_TopLeft.equals(this.m_BottomRight)) {
            this.m_Dimension.setAttribute("ref", this.m_TopLeft.getName());
        } else {
            this.m_Dimension.setAttribute("ref", this.m_TopLeft.getName() + ":" + this.m_BottomRight.getName());
        }
    }

    public void addCol(Col col) {
        if (this.m_ColBitSet.get(col.idx)) {
            throw new IllegalStateException("Already a col " + col.idx);
        }
        while (this.m_ColList.size() <= col.idx) {
            this.m_ColList.add(null);
        }
        this.m_ColList.set(col.idx, col);
        this.m_ColBitSet.set(col.idx);
        this.m_Cols.addContent(col.getElement());
    }

    public int getColStart(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Col col = this.m_ColList.get(i);
            if (col == null) continue;
            n2 += col.width;
        }
        return n2;
    }

    public void mergeCells(Location location, Location location2) {
        Element element = new Element("mergeCell", Build.NS_S);
        element.setAttribute("ref", location.getName() + ":" + location2.getName());
        this.m_MergeCells.addContent(element);
    }

    public void addImage(Location location, Location location2, long l, long l2, BufferedImage bufferedImage) throws IOException {
        Object object;
        if (this.m_Drawing == null) {
            object = "/xl/drawings/drawing" + this.m_IDGenerator.getDrawingNo() + ".xml";
            this.m_Drawing = new Drawing((String)object);
            this.m_SubParts.add(this.m_Drawing);
            String string = this.addRelationship(new Relationship("http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing", (String)object));
            Element element = new Element("drawing", "http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            element.setAttribute("id", string, Build.NS_R2);
            this.m_Document.getRootElement().addContent(element);
        }
        object = new TwoCellAnchor();
        ((TwoCellAnchor)object).topLeft = location;
        ((TwoCellAnchor)object).bottomRight = location2;
        ((TwoCellAnchor)object).x = l * 914400L / 96L;
        ((TwoCellAnchor)object).y = l2 * 914400L / 96L;
        ((TwoCellAnchor)object).width = (long)bufferedImage.getWidth() * 914400L / 96L;
        ((TwoCellAnchor)object).height = (long)bufferedImage.getHeight() * 914400L / 96L;
        ((TwoCellAnchor)object).gid = this.m_IDGenerator.getGraphicsNo();
        ((TwoCellAnchor)object).imageLocation = this.storeImage(bufferedImage);
        this.m_Drawing.addTwoCellAnchor((TwoCellAnchor)object);
    }

    public String storeImage(BufferedImage bufferedImage) throws IOException {
        String string = "image" + this.m_IDGenerator.getImageNo() + ".png";
        String string2 = "/xl/media/" + string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
        this.m_SubParts.add(new BinaryPart(string2, "image/png", byteArrayOutputStream.toByteArray()));
        return string2;
    }

    public List<Part> getSubParts() {
        return Collections.unmodifiableList(this.m_SubParts);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        int n;
        if (this.m_Cols.getChildren().isEmpty()) {
            this.m_Cols.getParentElement().removeContent(this.m_Cols);
        }
        if ((n = this.m_MergeCells.getChildren().size()) == 0) {
            this.m_MergeCells.getParentElement().removeContent(this.m_MergeCells);
        } else {
            this.m_MergeCells.setAttribute("count", String.valueOf(n));
        }
        super.write(outputStream);
    }

    public static String normalizeName(String string) {
        string = string.replace('/', '_');
        string = string.replace('\\', '_');
        string = string.replace('?', '_');
        string = string.replace('*', '_');
        string = string.replace('[', '_');
        string = string.replace(']', '_');
        string = string.replace(':', '_');
        if ((string = string.replace('{', '_')).length() > 31) {
            string = string.substring(0, 31);
        }
        return string;
    }

    public static String numberedTitle(String string, int n) {
        int n2 = (string + n).length();
        if (n2 > 31) {
            int n3 = n2 - 31;
            string = string.substring(0, string.length() - n3);
        }
        return string + n;
    }

    protected void buildExtensionPoints() throws IOException {
        Element element = this.m_Document.getRootElement();
        this.m_Cols = Sheet.getElement(element, "/s:worksheet/s:cols");
        this.m_MergeCells = Sheet.getElement(element, "/s:worksheet/s:mergeCells");
        this.m_SheetData = Sheet.getElement(element, "/s:worksheet/s:sheetData");
        this.m_Dimension = Sheet.getElement(element, "/s:worksheet/s:dimension");
        assert (this.m_Cols != null);
        assert (this.m_MergeCells != null);
        assert (this.m_SheetData != null);
        assert (this.m_Dimension != null);
    }
}

