/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.xls;

import com.elixirtech.jdom.Element;
import com.elixirtech.opc.Build;
import com.elixirtech.opc.ContentTypes;
import com.elixirtech.opc.Package;
import com.elixirtech.opc.Part;
import com.elixirtech.opc.Relationship;
import com.elixirtech.opc.RelationshipsPart;
import com.elixirtech.opc.ResourcePart;
import com.elixirtech.opc.ZipWriter;
import com.elixirtech.opc.util.XMLUtil;
import com.elixirtech.opc.xls.BooleanCell;
import com.elixirtech.opc.xls.ExtendedXMLPart;
import com.elixirtech.opc.xls.IDGenerator;
import com.elixirtech.opc.xls.Location;
import com.elixirtech.opc.xls.NumberCell;
import com.elixirtech.opc.xls.SharedStrings;
import com.elixirtech.opc.xls.Sheet;
import com.elixirtech.opc.xls.Styles;
import com.elixirtech.opc.xls.TextCell;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class Workbook
extends ExtendedXMLPart {
    public static final String CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml";
    private static final String WORKBOOK = "com/elixirtech/opc/xls/parts/workbook.xml";
    private static final String WORKBOOK_RELS = "com/elixirtech/opc/xls/parts/workbook.xml.rels";
    private final SharedStrings m_SharedStrings = new SharedStrings();
    private final Styles m_Styles = new Styles();
    private final List<Part> m_SubParts = new ArrayList<Part>();
    private final IDGenerator m_IDGenerator = new IDGenerator();
    private Element m_Sheets;
    private int m_SheetId = 0;

    public Workbook() throws IOException {
        super("/xl/workbook.xml", CONTENT_TYPE);
        this.setDocument(XMLUtil.loadResource(WORKBOOK));
        this.buildExtensionPoints();
        this.buildResources();
        this.buildRelationships();
    }

    public Sheet newSheet(String string, String string2) throws IOException {
        Sheet sheet = new Sheet(this.m_IDGenerator, string, string2);
        this.addSheet(sheet);
        return sheet;
    }

    public Sheet nextSheet(String object) throws IOException {
        String string = "/xl/worksheets/sheet" + ++this.m_SheetId + ".xml";
        if (((String)object).trim().length() == 0) {
            object = "Sheet" + this.m_SheetId;
        }
        Sheet sheet = new Sheet(this.m_IDGenerator, string, (String)object);
        this.addSheet(sheet);
        return sheet;
    }

    public void output(OutputStream outputStream) throws IOException {
        Package package_ = new Package();
        RelationshipsPart relationshipsPart = package_.getRelationships();
        relationshipsPart.addRelationship(new Relationship("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument", "xl/workbook.xml"));
        relationshipsPart.addRelationship(new Relationship("http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties", "docProps/app.xml"));
        relationshipsPart.addRelationship(new Relationship("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties", "docProps/core.xml"));
        package_.addPart(this);
        for (Part part : this.getSubParts()) {
            package_.addPart(part);
        }
        package_.addPart(new ContentTypes(package_));
        ZipWriter.write(package_, outputStream);
    }

    public IDGenerator getIDGenerator() {
        return this.m_IDGenerator;
    }

    public TextCell newTextCell(Location location, String string) {
        int n = this.m_SharedStrings.addString(string);
        return new TextCell(location, n);
    }

    public BooleanCell newBooleanCell(Location location, boolean bl) {
        return new BooleanCell(location, bl);
    }

    public BooleanCell newBooleanCell(Location location, Boolean bl) {
        return new BooleanCell(location, bl);
    }

    public NumberCell newNumberCell(Location location, long l) {
        return new NumberCell(location, l);
    }

    public NumberCell newNumberCell(Location location, double d) {
        return new NumberCell(location, d);
    }

    public List<Part> getSubParts() {
        ArrayList<Part> arrayList = new ArrayList<Part>();
        for (Part part : this.m_SubParts) {
            if (part instanceof Sheet) {
                arrayList.add(part);
                arrayList.addAll(((Sheet)part).getSubParts());
                continue;
            }
            arrayList.add(part);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Styles getStyles() {
        return this.m_Styles;
    }

    public void addSheet(Sheet sheet) {
        assert (sheet.getName().startsWith("/xl/worksheets/"));
        assert (sheet.getTitle().trim().length() > 0);
        if (this.getSheetNames().contains(sheet.getName())) {
            throw new IllegalArgumentException("Sheet named " + sheet.getName() + " already added");
        }
        if (this.getSheetTitles().contains(sheet.getTitle())) {
            this.fixTitle(sheet);
        }
        Element element = new Element("sheet", Build.NS_S);
        element.setAttribute("sheetId", this.m_IDGenerator.getSheetNo());
        String string = sheet.getName();
        String string2 = string.substring(4);
        element.setAttribute("name", sheet.getTitle());
        Relationship relationship = new Relationship("http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet", string2);
        element.setAttribute("id", this.addRelationship(relationship), Build.NS_R2);
        this.m_Sheets.addContent(element);
        this.m_SubParts.add(sheet);
    }

    protected void fixTitle(Sheet sheet) {
        Set<String> set = this.getSheetTitles();
        sheet.fixTitle(set);
    }

    protected void buildExtensionPoints() throws IOException {
        Element element = this.m_Document.getRootElement();
        this.m_Sheets = Workbook.getElement(element, "/s:workbook/s:sheets");
    }

    protected void buildResources() {
        this.m_SubParts.add(new ResourcePart("/xl/theme/theme1.xml", "application/vnd.openxmlformats-officedocument.theme+xml", "com/elixirtech/opc/xls/parts/theme/theme1.xml"));
        this.m_SubParts.add(new ResourcePart("/docProps/app.xml", "application/vnd.openxmlformats-officedocument.extended-properties+xml", "com/elixirtech/opc/xls/parts/docProps/app.xml"));
        this.m_SubParts.add(new ResourcePart("/docProps/core.xml", "application/vnd.openxmlformats-package.core-properties+xml", "com/elixirtech/opc/xls/parts/docProps/core.xml"));
        this.m_SubParts.add(this.m_SharedStrings);
        this.m_SubParts.add(this.m_Styles);
    }

    private void buildRelationships() throws IOException {
        this.initRelationships();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(WORKBOOK_RELS);
        this.m_Relationships.loadRelationships(inputStream);
        Relationship relationship = new Relationship("http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings", "sharedStrings.xml");
        this.m_Relationships.addRelationship(relationship);
        Relationship relationship2 = new Relationship("http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles", "styles.xml");
        this.m_Relationships.addRelationship(relationship2);
    }

    private Set<String> getSheetNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Part part : this.m_SubParts) {
            if (!(part instanceof Sheet)) continue;
            treeSet.add(part.getName());
        }
        return treeSet;
    }

    private Set<String> getSheetTitles() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Part part : this.m_SubParts) {
            if (!(part instanceof Sheet)) continue;
            treeSet.add(((Sheet)part).getTitle());
        }
        return treeSet;
    }
}

