/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.xls.style;

import com.elixirtech.jdom.Element;
import com.elixirtech.opc.xls.style.FixedFormats;
import com.elixirtech.opc.xls.style.Format;
import java.util.ArrayList;
import java.util.List;

public class FormatManager {
    private final Element m_NumFmts;
    private final List<FormatWrapper> m_FormatList = new ArrayList<FormatWrapper>();
    private int m_FreeId = 170;

    public FormatManager(Element element) {
        this.m_NumFmts = element;
    }

    public int getFormatIndex(Format format) {
        if (format == null) {
            return 0;
        }
        for (FormatWrapper formatWrapper : this.m_FormatList) {
            if (!formatWrapper.format.equals(format)) continue;
            return formatWrapper.id;
        }
        int n = FixedFormats.getId(format.code);
        if (n >= 0) {
            return n;
        }
        return this.addFormat(format);
    }

    private int addFormat(Format format) {
        int n = ++this.m_FreeId;
        this.addFormat(new FormatWrapper(format, n));
        return n;
    }

    private void addFormat(FormatWrapper formatWrapper) {
        this.m_FormatList.add(formatWrapper);
        this.m_NumFmts.addContent(formatWrapper.format.getElement(formatWrapper.id));
        this.m_NumFmts.setAttribute("count", String.valueOf(this.m_FormatList.size()));
    }

    private static class FormatWrapper {
        public final Format format;
        public final int id;

        public FormatWrapper(Format format, int n) {
            this.format = format;
            this.id = n;
        }

        public boolean equals(Object object) {
            if (object instanceof FormatWrapper) {
                FormatWrapper formatWrapper = (FormatWrapper)object;
                return this.format.equals(formatWrapper.format);
            }
            return false;
        }

        public int hashCode() {
            return this.format.hashCode();
        }
    }
}

