/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.property;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.i18n.Name;
import com.elixirtech.property.IMasterPropertyList;
import com.elixirtech.property.IStyle;
import com.elixirtech.property.PropertyData;
import com.elixirtech.property.PropertyType;
import java.util.Collection;

public final class DefaultStyle
implements IStyle {
    private static final long serialVersionUID = 1L;
    static DefaultStyle m_DefaultStyle = new DefaultStyle();
    static IMasterPropertyList m_MasterPropertyList = new NullMasterPropertyList();
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DefaultStyle.class);

    public static DefaultStyle current() {
        return m_DefaultStyle;
    }

    @Override
    public String getName() {
        return "Default";
    }

    @Override
    public Object getValue(Name name) {
        Object object = m_MasterPropertyList.getDefaultValue(name);
        if (object == null && !m_MasterPropertyList.contains(name)) {
            m_Log.warn((Object)("No property " + name.getName() + " in MasterPropertyList"));
        }
        return object;
    }

    private DefaultStyle() {
    }

    private static class NullMasterPropertyList
    implements IMasterPropertyList {
        private NullMasterPropertyList() {
        }

        @Override
        public Collection<PropertyData> getPropertyData() {
            this.ensureLoaded();
            return m_MasterPropertyList.getPropertyData();
        }

        @Override
        public PropertyType getPropertyType(Name name) {
            this.ensureLoaded();
            return m_MasterPropertyList.getPropertyType(name);
        }

        @Override
        public Object getDefaultValue(Name name) {
            this.ensureLoaded();
            return m_MasterPropertyList.getDefaultValue(name);
        }

        @Override
        public boolean contains(Name name) {
            this.ensureLoaded();
            return m_MasterPropertyList.contains(name);
        }

        @Override
        public boolean isInherited(Name name) {
            this.ensureLoaded();
            return m_MasterPropertyList.isInherited(name);
        }

        @Override
        public Object getValue(Name name, String string) {
            this.ensureLoaded();
            return m_MasterPropertyList.getValue(name, string);
        }

        @Override
        public void register(Name name, PropertyType propertyType, Object object, boolean bl, boolean bl2) {
            this.ensureLoaded();
            m_MasterPropertyList.register(name, propertyType, object, bl, bl2);
        }

        private void ensureLoaded() {
            m_MasterPropertyList = (IMasterPropertyList)Elixir.get(IMasterPropertyList.class);
        }
    }
}

