/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.property;

import com.elixirtech.arch.ElxLoggerJ;

public class PropertyType {
    public static final int TYPE_NONE = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_INTEGER = 3;
    public static final int TYPE_BOOLEAN = 4;
    public static final int TYPE_COLOUR = 5;
    public static final int TYPE_TWIP = 6;
    public static final int TYPE_POINT = 7;
    public static final int TYPE_CHOICE = 100;
    public static final PropertyType NONE = new PropertyType(1, "None");
    public static final PropertyType STRING = new PropertyType(2, "String");
    public static final PropertyType INTEGER = new PropertyType(3, "Integer");
    public static final PropertyType BOOLEAN = new PropertyType(4, "Boolean");
    public static final PropertyType COLOUR = new PropertyType(5, "Color");
    public static final PropertyType TWIP = new PropertyType(6, "Twip");
    public static final PropertyType POINT = new PropertyType(7, "Point");
    private final int m_Type;
    private final String m_Name;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PropertyType.class);

    protected PropertyType(int n, String string) {
        this.m_Type = n;
        this.m_Name = string;
    }

    public String getName() {
        return this.m_Name;
    }

    public int getTypeId() {
        return this.m_Type;
    }

    public String toString(Object object) {
        if (object == null) {
            return "";
        }
        switch (this.m_Type) {
            case 2: {
                return (String)object;
            }
            case 3: {
                return ((Integer)object).toString();
            }
            case 4: {
                return object == Boolean.TRUE ? "Yes" : "No";
            }
            case 5: {
                return (String)object;
            }
            case 6: {
                return ((Integer)object).toString();
            }
            case 7: {
                return ((Integer)object).toString();
            }
            case 100: {
                return object.toString();
            }
        }
        m_Log.warn((Object)("toString() Unknown property type: " + this.m_Type));
        return "";
    }

    public Object toType(String string) {
        switch (this.m_Type) {
            case 2: {
                return string;
            }
            case 3: 
            case 6: 
            case 7: {
                try {
                    return new Integer(string);
                }
                catch (NumberFormatException numberFormatException) {
                    m_Log.error((Object)("NumberFormatException: " + string + " is not an integer"));
                    return 0;
                }
            }
            case 4: {
                return "Yes".equals(string) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return string;
            }
            case 100: {
                return string;
            }
        }
        m_Log.warn((Object)("toType() Unknown property type: " + this.m_Type));
        return "";
    }

    public Class<?> getTypeClass() {
        switch (this.m_Type) {
            case 2: 
            case 5: 
            case 100: {
                return String.class;
            }
            case 3: 
            case 6: {
                return Integer.class;
            }
            case 7: {
                return Integer.class;
            }
            case 4: {
                return Boolean.class;
            }
        }
        m_Log.warn((Object)("toType() Unknown property type: " + this.m_Type));
        return String.class;
    }

    public String toString() {
        return "PropertyType[" + this.m_Type + "," + this.m_Name + "]";
    }

    public boolean equals(Object object) {
        if (object instanceof PropertyType) {
            return ((PropertyType)object).m_Name.equals(this.m_Name);
        }
        return false;
    }

    public int hashCode() {
        return this.m_Name.hashCode();
    }
}

