/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2;

import com.elixirtech.arch.ElixirContainer;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.MimeType;

public class RenderContainer {
    protected ElixirContainer m_Container;
    protected MimeType m_MimeType;
    protected int m_Id;
    private static ThreadLocal<RenderContainer> m_Current = new ThreadLocal();
    private static int m_NextId;
    private static final ElxLoggerJ m_Log;

    public static RenderContainer current() {
        return m_Current.get();
    }

    public static <T> T get(Class<T> clazz) {
        RenderContainer renderContainer = m_Current.get();
        if (renderContainer == null) {
            throw new IllegalThreadStateException("This thread doesn't have a RenderContainer");
        }
        return (T)renderContainer.m_Container.get(clazz);
    }

    public static <T> T getOrNull(Class<T> clazz) {
        RenderContainer renderContainer = m_Current.get();
        if (renderContainer == null) {
            return null;
        }
        return (T)renderContainer.m_Container.get(clazz);
    }

    public static void install(RenderContainer renderContainer) {
        if (m_Current.get() != null) {
            m_Log.error((Object)"Constructor: This thread already has a RenderContainer");
            RenderContainer renderContainer2 = m_Current.get();
            m_Log.error((Object)("old RenderContainer is: " + renderContainer2.m_Id));
            m_Log.error((Object)("Thread is: " + Thread.currentThread()));
        }
        m_Current.set(renderContainer);
        if (m_Log.isDebugEnabled()) {
            m_Log.debug((Object)("installed " + renderContainer.m_Id + " " + Thread.currentThread()));
        }
    }

    public static void release() {
        RenderContainer renderContainer = m_Current.get();
        m_Current.set(null);
        if (m_Log.isDebugEnabled()) {
            m_Log.debug((Object)("released " + renderContainer.m_Id + " " + Thread.currentThread()));
        }
    }

    public RenderContainer(MimeType mimeType) {
        if (m_Current.get() != null) {
            m_Log.error((Object)"Constructor: This thread already has a RenderContainer");
            RenderContainer renderContainer = m_Current.get();
            m_Log.error((Object)("old RenderContainer is: " + renderContainer.m_Id));
            m_Log.error((Object)("Thread is: " + Thread.currentThread()));
        }
        this.m_Id = RenderContainer.nextId();
        this.m_Container = new ElixirContainer();
        this.m_MimeType = mimeType;
        m_Current.set(this);
        this.m_Container.register(RenderContainer.class, this);
        if (m_Log.isDebugEnabled()) {
            m_Log.debug((Object)("created " + this.m_Id + " " + Thread.currentThread()));
        }
    }

    public MimeType getMimeType() {
        return this.m_MimeType;
    }

    public void dispose() {
        this.m_Container.dispose();
        m_Current.set(null);
        if (m_Log.isDebugEnabled()) {
            m_Log.debug((Object)("disposed " + this.m_Id + " " + Thread.currentThread()));
        }
    }

    protected ElixirContainer getContainer() {
        return this.m_Container;
    }

    private static synchronized int nextId() {
        return m_NextId++;
    }

    static {
        m_Log = ElxLoggerJ.getLogger(RenderContainer.class);
    }
}

