/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.data;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataTable;
import com.elixirtech.report2.data.IDataCache;
import com.elixirtech.report2.data.IDataCacheManager;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractDataCacheManager
implements IDataCacheManager {
    protected Map<Object, IDataCache> m_Caches = new HashMap<Object, IDataCache>();

    @Override
    public IDataCache loadCache(String string, Map<String, String> map) throws DataException {
        return this.loadCache(string, string, map);
    }

    @Override
    public IDataCache loadCache(String string, Object object, Map<String, String> map) throws DataException {
        IDataCache iDataCache = this.newCache(string, map);
        this.m_Caches.put(object, iDataCache);
        return iDataCache;
    }

    @Override
    public abstract Object getCacheName(Object var1);

    @Override
    public boolean hasCache(Object object) {
        return this.m_Caches.containsKey(this.getCacheName(object));
    }

    @Override
    public IDataCache getCache(Object object) throws DataException {
        IDataCache iDataCache = this.m_Caches.get(this.getCacheName(object));
        if (iDataCache == null) {
            iDataCache = this.loadCache(String.valueOf(object), object, new HashMap<String, String>());
        }
        return iDataCache;
    }

    @Override
    public void putCache(Object object, IDataCache iDataCache) {
        this.m_Caches.put(object, iDataCache);
    }

    public void putCache(DataTable dataTable) {
        this.m_Caches.put(dataTable.getName(), this.newCache(dataTable));
    }

    @Override
    public void removeCache(Object object) {
        this.m_Caches.remove(object);
    }

    protected abstract IDataCache newCache(DataTable var1);

    protected abstract IDataCache newCache(String var1, Map<String, String> var2) throws DataException;
}

