/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.data;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.report2.RenderContainer;
import com.elixirtech.report2.data.AbstractDataCache;
import com.elixirtech.report2.data.IDataCache;
import com.elixirtech.report2.logical.OverrideReportSubstitution;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.raw.model.DataSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataCache
extends AbstractDataCache {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DataCache.class);

    public DataCache(String string) throws DataException {
        super(string);
    }

    public DataCache(String string, Map<String, String> map) throws DataException {
        super(string, map);
    }

    public DataCache(String string, DataTable dataTable) {
        super(string, dataTable);
    }

    @Override
    public void reset(Map<String, String> map) throws DataException {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        m_Log.info((Object)("reset(" + map.entrySet().toString() + ")"));
        try {
            DataSourceManager dataSourceManager = RenderContainer.get(DataSourceManager.class);
            RenderStack renderStack = RenderStack.current();
            DataSource dataSource = renderStack.getDataSource(this.m_Name);
            if (dataSource == null) {
                throw new DataException("No datasource " + this.m_Name + " to reload from");
            }
            IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, dataSource.getDataSourceName());
            List<Parameter> list = iDataSource.getParameters();
            this.m_HasParameters = list.size() > 0;
            DefaultPushContext defaultPushContext = new DefaultPushContext();
            OverrideReportSubstitution overrideReportSubstitution = new OverrideReportSubstitution(map);
            for (Map.Entry<String, String> object : map.entrySet()) {
                defaultPushContext.setParameter(object.getKey(), object.getValue());
            }
            for (Parameter parameter : list) {
                String string = parameter.getName();
                com.elixirtech.report2.raw.model.Parameter parameter2 = dataSource.getParameter(string);
                String string2 = null;
                if (parameter2 != null) {
                    string2 = parameter2.getValue();
                    if (StringUtil.isEmpty(string2 = ArgumentMap.substitute(string2, overrideReportSubstitution))) {
                        string2 = null;
                    }
                }
                if (string2 == null) {
                    string2 = renderStack.getProperty(string);
                }
                if (string2 == null) {
                    string2 = parameter.getDefaultValue();
                }
                if (string2 == null) continue;
                defaultPushContext.setParameter(string, string2);
            }
            this.m_Table = DataTable.build(defaultPushContext, iDataSource);
            this.m_Schema = this.m_Table.getSchema();
            this.m_RecordIndex = 0;
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error in resetCache: " + exception), (Throwable)exception);
            throw exception;
        }
    }

    @Override
    public IDataCache filter(String string, Object object) {
        int n = this.getColumnIndex(string);
        DataTable dataTable = this.m_Table.select(this.m_Table.getGroups(), n, object);
        return new DataCache(this.m_Name, dataTable);
    }
}

