/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.data.util;

import com.elixirtech.arch.ElxLoggerJ;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class Resource {
    private static HashMap<String, ResourceBundle> m_Bundles = new HashMap(1);
    private static Locale m_Locale;
    private static final ElxLoggerJ m_Log;

    public static void loadBundle(String string, Locale locale) {
        m_Log.info((Object)("loading " + string));
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
        m_Bundles.put(string, resourceBundle);
    }

    public static void removeBundle(String string) {
        m_Log.debug((Object)("removing " + string));
        m_Bundles.remove(string);
    }

    public static void clearAllBundles() {
        m_Log.debug((Object)"clearing all bundles");
        m_Bundles.clear();
    }

    public static String getText(String string, String string2) {
        ResourceBundle resourceBundle = m_Bundles.get(string);
        if (resourceBundle == null) {
            Resource.loadBundle(string, m_Locale);
            Resource.getText(string, string2);
        } else {
            try {
                return resourceBundle.getString(string2);
            }
            catch (Exception exception) {
                m_Log.error((Object)("getText(): " + exception), (Throwable)exception);
            }
        }
        return "Error: getText(" + string + "," + string2 + ")";
    }

    public static String getLocaleBasedText(String string, String string2, Locale locale) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(string2);
            }
            catch (Exception exception) {
                m_Log.error((Object)("getLocaleBasedText(): " + exception), (Throwable)exception);
            }
        }
        return "Error getLocaleBasedText(" + string + "," + string2 + ")";
    }

    static {
        m_Log = ElxLoggerJ.getLogger(Resource.class);
    }
}

