/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.Empty;
import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.util.ByteCounterOutputStream;
import com.elixirtech.util.FileUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class CSVPageListener
implements PageListener {
    public static final int TOLERANCE = 20;
    private Result m_Result;
    private LogicalReport m_LogicalReport;
    private PrintWriter m_Writer;
    private String m_Separator = ",";
    private String m_Qualifier = null;

    public CSVPageListener(Result result) {
        this.m_Result = result;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        this.m_LogicalReport = pageSource.getLogicalReport();
    }

    private void initWriter() {
        try {
            String string = "UTF-8";
            RenderDetails renderDetails = this.m_LogicalReport.getRenderDetails("text/csv");
            if (renderDetails != null) {
                string = renderDetails.getParameterValue("Encoding", string);
                this.m_Separator = renderDetails.getParameterValue("Separator", this.m_Separator);
                if ("Tab".equals(this.m_Separator)) {
                    this.m_Separator = "\t";
                }
                if ("Semicolon".equals(this.m_Separator)) {
                    this.m_Separator = ";";
                }
                if ("Colon".equals(this.m_Separator)) {
                    this.m_Separator = ":";
                }
                if ("Comma".equals(this.m_Separator)) {
                    this.m_Separator = ",";
                }
                if ("Space".equals(this.m_Separator)) {
                    this.m_Separator = " ";
                }
                this.m_Qualifier = renderDetails.getParameterValue("Qualifier", this.m_Qualifier);
                if ("None".equals(this.m_Qualifier)) {
                    this.m_Qualifier = null;
                }
            }
            ByteCounterOutputStream byteCounterOutputStream = new ByteCounterOutputStream(this.m_Result.getOutputStream());
            this.m_Writer = new PrintWriter(new OutputStreamWriter((OutputStream)byteCounterOutputStream, string));
            if ("UTF-8".equals(string) && System.getProperty("com.elixirtech.report.csv.utf8.bom") != null) {
                this.m_Writer.write(65279);
            }
        }
        catch (Throwable throwable) {
            throw new RenderException("Can't start report: " + throwable, throwable);
        }
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void addPage(Page page) throws RenderException {
        if (this.m_Writer == null) {
            this.initWriter();
        }
        Iterator<BodyPart> iterator = page.getBody().getBodyPartIterator();
        while (iterator.hasNext()) {
            BodyPart bodyPart = iterator.next();
            this.outputBodyPart(bodyPart, this.m_Writer, this.m_Separator, this.m_Qualifier);
        }
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        FileUtil.close(this.m_Writer);
        this.m_Result = null;
        this.m_Writer = null;
    }

    protected void outputBodyPart(BodyPart bodyPart, PrintWriter printWriter, String string, String string2) {
        ArrayList<LogicalElement> arrayList = new ArrayList<LogicalElement>();
        Iterator<LogicalElement> iterator = bodyPart.getLogicalElementIterator();
        while (iterator.hasNext()) {
            this.addToList(arrayList, iterator.next());
        }
        if (arrayList.size() > 0) {
            Object object;
            Collections.sort(arrayList, new YOrdering());
            int n = ((LogicalElement)arrayList.get(0)).getTop();
            Iterator iterator2 = arrayList.iterator();
            ArrayList<StringBuffer> arrayList2 = new ArrayList<StringBuffer>();
            StringBuffer stringBuffer = new StringBuffer();
            arrayList2.add(stringBuffer);
            boolean bl = true;
            while (iterator2.hasNext()) {
                int n2;
                LogicalElement logicalElement;
                object = iterator2.next();
                if (object instanceof Text) {
                    logicalElement = (Text)object;
                    n2 = logicalElement.getTop();
                    if (!CSVPageListener.withinTolerance(n, n2)) {
                        n = n2;
                        stringBuffer = new StringBuffer();
                        arrayList2.add(stringBuffer);
                        bl = true;
                    }
                    if (!bl) {
                        stringBuffer.append(string);
                    }
                    if (string2 != null) {
                        stringBuffer.append(string2);
                    }
                    stringBuffer.append(((Text)logicalElement).getText());
                    if (string2 != null) {
                        stringBuffer.append(string2);
                    }
                    bl = false;
                    continue;
                }
                if (!(object instanceof Empty)) continue;
                logicalElement = (Empty)object;
                n2 = logicalElement.getTop();
                if (!CSVPageListener.withinTolerance(n, n2)) {
                    n = n2;
                    stringBuffer = new StringBuffer();
                    arrayList2.add(stringBuffer);
                    bl = true;
                }
                if (!bl) {
                    stringBuffer.append(string);
                }
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
                bl = false;
            }
            object = arrayList2.iterator();
            while (object.hasNext()) {
                printWriter.print(((StringBuffer)object.next()).toString());
                printWriter.print("\r\n");
            }
        }
    }

    private void addToList(List<LogicalElement> list, LogicalElement logicalElement) {
        if (logicalElement instanceof ILogicalElementHolder) {
            Iterator<LogicalElement> iterator = ((ILogicalElementHolder)((Object)logicalElement)).getLogicalElementIterator();
            while (iterator.hasNext()) {
                this.addToList(list, iterator.next());
            }
        } else if (logicalElement instanceof Text) {
            list.add(logicalElement);
        } else if (logicalElement instanceof Empty) {
            list.add(logicalElement);
        }
    }

    static boolean withinTolerance(int n, int n2) {
        return n2 > n - 20 && n2 < n + 20;
    }

    private static class YOrdering
    implements Comparator<LogicalElement> {
        private YOrdering() {
        }

        @Override
        public int compare(LogicalElement logicalElement, LogicalElement logicalElement2) {
            int n;
            int n2 = logicalElement.getTop();
            if (CSVPageListener.withinTolerance(n2, n = logicalElement2.getTop())) {
                int n3;
                int n4 = logicalElement.getLeft();
                if (n4 < (n3 = logicalElement2.getLeft())) {
                    return -1;
                }
                if (n4 > n3) {
                    return 1;
                }
                return 0;
            }
            if (n2 < n) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof YOrdering;
        }
    }
}

