/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.IPassThrough;
import com.elixirtech.glint.Pen;
import com.elixirtech.graphics.font.Font;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.report2.engine.PCLConfig;
import com.elixirtech.report2.engine.PCLFontMeasurerFactory;
import com.elixirtech.report2.engine.PCLStream;
import com.elixirtech.report2.engine.ResourceManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.text.NumberFormat;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;

public class GlintPCL
implements IGlint,
IPassThrough {
    private static final String RESET = "\u001bE";
    private static final String EXIT_LANGUAGE = "\u001b%-12345X";
    private static final int MODE_PCL = 2;
    private static final int MODE_HPGL2 = 3;
    public static final int SIDES_ONE_SIDED = 0;
    public static final int SIDES_TWO_SIDED_LONG_EDGE = 1;
    public static final int SIDES_TWO_SIDED_SHORT_EDGE = 2;
    public static final int SIDES_IGNORE = 99;
    public static int DPI = 150;
    public static boolean COLOUR = true;
    private ResourceManager m_ResourceManager;
    private Set<Integer> m_DownloadedFonts = new HashSet<Integer>();
    private PCLConfig m_Config;
    private PCLStream m_Output;
    private final int m_Sides;
    private int m_InitCount;
    private int m_Width;
    private int m_Height;
    private int m_Orientation;
    private int m_Mode = 2;
    private int m_OffsetX;
    private int m_OffsetY;
    private Map<String, Integer> m_FontMap = new HashMap<String, Integer>();
    private int m_FontId = -1;
    private static NumberFormat m_1DP;
    private static NumberFormat m_2DP;
    private static final ElxLoggerJ m_Log;

    public static void startOutput(PCLStream pCLStream) {
        m_Log.info((Object)"GlintPCL version 2009-04-21.2");
        pCLStream.add(EXIT_LANGUAGE);
        pCLStream.add(RESET);
    }

    public static void endOutput(PCLStream pCLStream) {
        pCLStream.add("\u001b&l1T");
        pCLStream.add(EXIT_LANGUAGE);
        pCLStream.add(RESET);
        pCLStream.flush();
    }

    public static void setNoCopies(PCLStream pCLStream, int n) {
        pCLStream.add("\u001b&l" + n + "X");
    }

    public GlintPCL(PCLConfig pCLConfig, PCLStream pCLStream, int n) {
        this.m_Config = pCLConfig;
        this.m_Output = pCLStream;
        this.m_Sides = n;
        this.m_ResourceManager = new ResourceManager();
    }

    public void defineFontSlot(String string, int n) {
        this.m_FontMap.put(string, new Integer(n));
    }

    @Override
    public void init(int n, int n2, int n3) {
        ++this.m_InitCount;
        this.m_Orientation = n3;
        boolean bl = false;
        if (this.m_Width != n) {
            this.m_Width = n;
            bl = true;
        }
        if (this.m_Height != n2) {
            this.m_Height = n2;
            bl = true;
        }
        if (bl && this.m_InitCount > 1) {
            this.m_Output.add(RESET);
            this.m_InitCount = 1;
        }
        if (this.m_InitCount == 1 && this.m_Sides != 99) {
            this.m_Output.add("\u001b&l" + this.m_Sides + "S");
        }
        if (this.m_InitCount > 1 && this.isDuplex()) {
            this.m_Output.add("\u001b&a0G");
        }
        int n4 = 0;
        if (n3 == 2) {
            n4 = 1;
        }
        this.m_Output.add("\u001b&l" + n4 + "O");
        this.outputPageSize();
        this.m_Output.add("\u001b&u7200D");
        this.m_Output.add("\u001b&l0E");
        this.m_Output.add("\u001b&a0L");
    }

    public void setPCLOffset(int n, int n2) {
        this.m_Output.add("\u001b&l" + this.decipoints(n) + "U");
        this.m_Output.add("\u001b&l" + this.decipoints(n2) + "Z");
    }

    private boolean isDuplex() {
        return this.m_Sides == 1 || this.m_Sides == 2;
    }

    public void enterHPGL2(int n, int n2, int n3, int n4) {
        if (this.m_Mode != 3) {
            this.m_Output.add("\u001b&a" + n + "H\u001b&a" + n2 + "V");
            this.m_Output.add("\u001b*c" + n3 + "X\u001b*c" + n4 + "Y");
            this.m_Output.add("\u001bc0T");
            this.m_Output.add("\u001b%0B");
            this.m_Output.add("IN;");
            this.m_Mode = 3;
        }
    }

    public void enterPCL() {
        if (this.m_Mode != 2) {
            this.m_Output.add("\u001b%0A");
            this.m_Mode = 2;
        }
    }

    @Override
    public void passThrough(String string, byte[] byArray) {
        this.enterPCL();
        if (MimeTypes.PCL().value().equals(string)) {
            this.m_Output.add(byArray);
        }
    }

    @Override
    public IGlint.FontId defineFont(com.elixirtech.glint.Font font) {
        return this.m_ResourceManager.defineFont(font);
    }

    @Override
    public IGlint.ColorId defineColor(com.elixirtech.glint.Color color) {
        return this.m_ResourceManager.defineColor(color);
    }

    @Override
    public IGlint.ImageId defineImage(com.elixirtech.glint.Image image) {
        return this.m_ResourceManager.defineImage(image);
    }

    @Override
    public IGlint.PenId definePen(Pen pen) {
        return this.m_ResourceManager.definePen(pen);
    }

    @Override
    public IGlint.StringId defineString() {
        return this.m_ResourceManager.defineString();
    }

    @Override
    public void setString(IGlint.StringId stringId, String string) {
        this.m_ResourceManager.setString(stringId, string);
    }

    @Override
    public com.elixirtech.glint.Font getFont(IGlint.FontId fontId) {
        return this.m_ResourceManager.getFont(fontId);
    }

    @Override
    public com.elixirtech.glint.Color getColor(IGlint.ColorId colorId) {
        return this.m_ResourceManager.getColor(colorId);
    }

    @Override
    public com.elixirtech.glint.Image getImage(IGlint.ImageId imageId) {
        return this.m_ResourceManager.getImage(imageId);
    }

    @Override
    public Pen getPen(IGlint.PenId penId) {
        return this.m_ResourceManager.getPen(penId);
    }

    @Override
    public String getString(IGlint.StringId stringId) {
        return this.m_ResourceManager.getString(stringId);
    }

    @Override
    public int getWidth() {
        return this.m_Width;
    }

    @Override
    public int getHeight() {
        return this.m_Height;
    }

    @Override
    public int getOrientation() {
        return this.m_Orientation;
    }

    @Override
    public void offsetOrigin(int n, int n2) {
        this.m_OffsetX += n;
        this.m_OffsetY += n2;
    }

    @Override
    public void setOrigin(int n, int n2) {
        this.m_OffsetX = n;
        this.m_OffsetY = n2;
    }

    @Override
    public int getOriginX() {
        return this.m_OffsetX;
    }

    @Override
    public int getOriginY() {
        return this.m_OffsetY;
    }

    @Override
    public void setURL(String string, String string2) {
    }

    @Override
    public void resetURL() {
    }

    @Override
    public void drawLine(IGlint.PenId penId, int n, int n2, int n3, int n4) {
    }

    @Override
    public void drawPolyline(IGlint.PenId penId, int[] nArray, int[] nArray2) {
    }

    @Override
    public void drawRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
        this.drawCellRect(penId, colorId, n, n2, n3, n4, 15);
    }

    @Override
    public void drawCellRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5) {
        if (colorId.id != 0 || penId.id != 0) {
            this.enterPCL();
            this.m_Output.add("\u001b&a0P");
            if (penId.id != 0) {
                n += this.m_OffsetX;
                n2 += this.m_OffsetY;
                Pen pen = this.getPen(penId);
                short s = pen.getWidth();
                if (s > 0) {
                    if ((n5 & 2) != 0) {
                        this.m_Output.add("\u001b&a" + this.decipoints(n) + "H");
                        this.m_Output.add("\u001b&a" + this.decipoints(n2) + "V");
                        this.m_Output.add("\u001b*c" + this.decipoints(n3) + "h" + this.decipoints(s) + "v0P");
                    }
                    if ((n5 & 4) != 0) {
                        this.m_Output.add("\u001b&a" + this.decipoints(n + n3 - s) + "H");
                        this.m_Output.add("\u001b&a" + this.decipoints(n2) + "V");
                        this.m_Output.add("\u001b*c" + this.decipoints(s) + "h" + this.decipoints(n4) + "v0P");
                    }
                    if ((n5 & 8) != 0) {
                        this.m_Output.add("\u001b&a" + this.decipoints(n) + "H");
                        this.m_Output.add("\u001b&a" + this.decipoints(n2 + n4 - s) + "V");
                        this.m_Output.add("\u001b*c" + this.decipoints(n3) + "h" + this.decipoints(s) + "v0P");
                    }
                    if ((n5 & 1) != 0) {
                        this.m_Output.add("\u001b&a" + this.decipoints(n) + "H");
                        this.m_Output.add("\u001b&a" + this.decipoints(n2) + "V");
                        this.m_Output.add("\u001b*c" + this.decipoints(s) + "h" + this.decipoints(n4) + "v0P");
                    }
                }
            }
        }
    }

    @Override
    public void drawRoundRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public void drawRoundCellRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    @Override
    public void drawEllipse(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
    }

    @Override
    public void drawPolygon(IGlint.PenId penId, IGlint.ColorId colorId, int[] nArray, int[] nArray2) {
    }

    @Override
    public void drawImage(IGlint.ImageId imageId, int n, int n2) {
        com.elixirtech.glint.Image image = this.getImage(imageId);
        Image image2 = image.asAWTImage();
        int n3 = image2.getWidth(null) * DPI / 72;
        int n4 = image2.getHeight(null) * DPI / 72;
        if (n3 > 0 && n4 > 0) {
            BufferedImage bufferedImage = this.createImage(n3, n4);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n3, n4);
            graphics2D.scale((float)DPI / 72.0f, (float)DPI / 72.0f);
            graphics2D.drawImage(image2, 0, 0, null);
            graphics2D.dispose();
            this.drawImage(bufferedImage, n, n2);
            bufferedImage.flush();
        }
    }

    private void drawImage(BufferedImage bufferedImage, int n, int n2) {
        this.enterPCL();
        this.m_Output.add("\u001b&a0P");
        this.m_Output.add("\u001b&a" + this.decipoints(n += this.m_OffsetX) + "H");
        this.m_Output.add("\u001b&a" + this.decipoints(n2 += this.m_OffsetY) + "V");
        if (COLOUR) {
            this.outputColour(bufferedImage);
        } else {
            this.outputDithered(bufferedImage);
        }
        this.m_Output.add("\u001b*rC");
    }

    private void outputDithered(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        this.m_Output.add("\u001b*r0F");
        this.m_Output.add("\u001b*t" + DPI + "R");
        this.m_Output.add("\u001b*r" + n + "S");
        this.m_Output.add("\u001b*r" + n2 + "T");
        this.m_Output.add("\u001b*b0M");
        this.m_Output.add("\u001b*r1A");
        int[] nArray = bufferedImage.getRGB(0, 0, n, n2, null, 0, n);
        int n3 = 0;
        BitSet bitSet = new BitSet();
        for (int i = 0; i < n2; ++i) {
            bitSet.clear();
            for (int j = 0; j < n; ++j) {
                int n4 = nArray[n3 + j];
                int n5 = n4 & 0xFF;
                if (n5 < 128) {
                    bitSet.set(j);
                    continue;
                }
                if (n5 >= 196 || !this.dither(j, i)) continue;
                bitSet.set(j);
            }
            byte[] byArray = GlintPCL.toByteArray(bitSet);
            this.m_Output.add("\u001b*b" + byArray.length + "W");
            this.m_Output.add(byArray);
            n3 += n;
        }
    }

    private void outputColour(BufferedImage bufferedImage) {
        int n;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        this.m_Output.add("\u001b*r0F");
        this.m_Output.add("\u001b*t" + DPI + "R");
        this.m_Output.add("\u001b*r" + n2 + "S");
        this.m_Output.add("\u001b*r" + n3 + "T");
        this.m_Output.add("\u001b*r3U");
        this.m_Output.add("\u001b*r0F");
        byte[] byArray = new byte[]{0, 3, 0, 8, 8, 8};
        this.m_Output.add("\u001b*v6W");
        this.m_Output.add(byArray);
        this.m_Output.add("\u001b*r1A");
        this.m_Output.add("\u001b*b1M");
        int[] nArray = bufferedImage.getRGB(0, 0, n2, n3, null, 0, n2);
        byte[] byArray2 = new byte[n2 * 3];
        for (n = 0; n < byArray2.length; ++n) {
            byArray2[n] = 0;
        }
        n = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n4 = nArray[n + j];
                byArray2[j * 3] = (byte)(n4 >> 16 & 0xFF);
                byArray2[j * 3 + 1] = (byte)(n4 >> 8 & 0xFF);
                byArray2[j * 3 + 2] = (byte)(n4 & 0xFF);
            }
            this.sendRow(GlintPCL.rle(byArray2));
            n += n2;
        }
    }

    protected void sendPlane(byte[] byArray) {
        this.m_Output.add("\u001b*b" + byArray.length + "V");
        this.m_Output.add(byArray);
    }

    protected void sendRow(byte[] byArray) {
        this.m_Output.add("\u001b*b" + byArray.length + "W");
        this.m_Output.add(byArray);
    }

    protected BufferedImage createImage(int n, int n2) {
        return new BufferedImage(n, n2, COLOUR ? 2 : 10);
    }

    private boolean dither(int n, int n2) {
        return (n & 1) == (n2 & 1);
    }

    private static byte[] toByteArray(BitSet bitSet) {
        byte[] byArray = new byte[bitSet.length() / 8 + 1];
        for (int i = 0; i < bitSet.length(); ++i) {
            if (!bitSet.get(i)) continue;
            int n = i / 8;
            byArray[n] = (byte)(byArray[n] | 1 << 7 - i % 8);
        }
        return byArray;
    }

    @Override
    public void drawScaledImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4) {
        com.elixirtech.glint.Image image = this.getImage(imageId);
        Image image2 = image.asAWTImage();
        int n5 = n3 * DPI / 1440;
        int n6 = n4 * DPI / 1440;
        if (n5 > 0 && n6 > 0) {
            BufferedImage bufferedImage = this.createImage(n5, n6);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n5, n6);
            graphics2D.drawImage(image2, 0, 0, n5, n6, null);
            graphics2D.dispose();
            this.drawImage(bufferedImage, n, n2);
            bufferedImage.flush();
        }
    }

    @Override
    public void drawSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6) {
        com.elixirtech.glint.Image image = this.getImage(imageId);
        Image image2 = image.asAWTImage();
        int n7 = n5 * DPI / 72;
        int n8 = n6 * DPI / 72;
        if (n7 > 0 && n8 > 0) {
            BufferedImage bufferedImage = this.createImage(n7, n8);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n7, n8);
            graphics2D.drawImage(image2, 0, 0, n7, n8, n3, n4, n3 + n5, n4 + n6, null);
            graphics2D.dispose();
            this.drawImage(bufferedImage, n, n2);
            bufferedImage.flush();
        }
    }

    @Override
    public void drawScaledSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        com.elixirtech.glint.Image image = this.getImage(imageId);
        Image image2 = image.asAWTImage();
        int n9 = n3 * DPI / 1440;
        int n10 = n4 * DPI / 1440;
        if (n9 > 0 && n10 > 0) {
            BufferedImage bufferedImage = this.createImage(n9, n10);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n9, n10);
            graphics2D.drawImage(image2, 0, 0, n9, n10, n5, n5, n5 + n7, n6 + n8, null);
            graphics2D.dispose();
            this.drawImage(bufferedImage, n, n2);
            bufferedImage.flush();
        }
    }

    @Override
    public void drawText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, String string) {
        n += this.m_OffsetX;
        n2 += this.m_OffsetY;
        this.enterPCL();
        if (n3 == 1) {
            this.m_Output.add("\u001b&a0P");
            this.m_Output.add("\u001b&a" + this.decipoints(n) + "H");
            this.m_Output.add("\u001b&a" + this.decipoints(n2) + "V");
            this.selectFont(fontId);
            this.m_Output.add(string);
        } else if (n3 == 2) {
            com.elixirtech.glint.Font font = this.getFont(fontId);
            Font font2 = new Font(font.getName(), font.isBold(), font.isItalic(), font.getSize());
            PCLFontMeasurerFactory pCLFontMeasurerFactory = new PCLFontMeasurerFactory();
            IFontMeasurer iFontMeasurer = pCLFontMeasurerFactory.getInstance(font2);
            float f = iFontMeasurer.getWidth(string);
            this.m_Output.add("\u001b&a0P");
            this.m_Output.add("\u001b&a" + this.decipoints((int)((float)n - f)) + "H");
            this.m_Output.add("\u001b&a" + this.decipoints(n2) + "V");
            this.selectFont(fontId);
            this.m_Output.add(string);
        }
    }

    @Override
    public void drawJustifiedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, String string) {
    }

    @Override
    public void drawRotatedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, String string) {
        n += this.m_OffsetX;
        n2 += this.m_OffsetY;
        this.enterPCL();
        if (n3 == 1) {
            this.m_Output.add("\u001b&a0P");
            this.m_Output.add("\u001b&a" + this.decipoints(n) + "H");
            this.m_Output.add("\u001b&a" + this.decipoints(n2) + "V");
            this.selectFont(fontId);
            if (n4 != 0) {
                this.m_Output.add("\u001b&a" + n4 + "P");
            }
            this.m_Output.add(string);
        }
    }

    @Override
    public void drawRotatedJustifiedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, String string) {
    }

    @Override
    public void drawRTF(int n, int n2, int n3, int n4, String string) {
    }

    @Override
    public void pushClip(int n, int n2, int n3, int n4) {
    }

    @Override
    public void pushClip(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    @Override
    public void popClip() {
    }

    @Override
    public void flush() {
        this.m_ResourceManager = null;
    }

    private void outputPageSize() {
        int n = 2;
        Dimension dimension = this.m_Width < this.m_Height ? new Dimension(this.m_Width, this.m_Height) : new Dimension(this.m_Height, this.m_Width);
        Dimension dimension2 = this.getSize(MediaSizeName.ISO_A4);
        Dimension dimension3 = this.getSize(MediaSizeName.ISO_A3);
        Dimension dimension4 = this.getSize(MediaSizeName.EXECUTIVE);
        Dimension dimension5 = this.getSize(MediaSizeName.LEDGER);
        Dimension dimension6 = this.getSize(MediaSizeName.NA_LEGAL);
        Dimension dimension7 = this.getSize(MediaSizeName.NA_LETTER);
        if (dimension.equals(dimension2)) {
            n = 26;
        } else if (dimension.equals(dimension3)) {
            n = 27;
        } else if (dimension.equals(dimension4)) {
            n = 1;
        } else if (dimension.equals(dimension5)) {
            n = 6;
        } else if (dimension.equals(dimension6)) {
            n = 3;
        } else if (dimension.equals(dimension7)) {
            n = 2;
        }
        this.m_Output.add("\u001b&l" + n + "A");
    }

    private Dimension getSize(MediaSizeName mediaSizeName) {
        MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
        int n = (int)(mediaSize.getX(25400) * 1440.0f);
        int n2 = (int)(mediaSize.getY(25400) * 1440.0f);
        return new Dimension(n, n2);
    }

    private void selectFont(IGlint.FontId fontId) {
        if (this.m_FontId != fontId.id) {
            com.elixirtech.glint.Font font = this.getFont(fontId);
            Integer n = new Integer(this.m_Config.getFontId(font.getName()));
            if (!this.m_DownloadedFonts.contains(n)) {
                this.m_Config.writeHeader(n, this.m_Output);
                this.m_Config.writeBytes(n, this.m_Output);
                this.m_DownloadedFonts.add(n);
            }
            float f = (float)font.getSize() / 20.0f;
            this.m_Config.selectFont(n, this.pt1dp(f), font.isBold(), font.isItalic(), this.m_Output);
            this.m_FontId = fontId.id;
        }
    }

    private int decipoints(int n) {
        return n / 2;
    }

    private String pt1dp(float f) {
        return m_1DP.format(f);
    }

    public static byte[] rle(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < byArray.length) {
            int n2;
            byte by = byArray[n];
            ++n;
            for (n2 = 0; n < byArray.length && byArray[n] == by && n2 < 255; ++n2, ++n) {
            }
            byteArrayOutputStream.write(n2);
            byteArrayOutputStream.write(by);
        }
        return byteArrayOutputStream.toByteArray();
    }

    static {
        m_Log = ElxLoggerJ.getLogger(GlintPCL.class);
        m_1DP = NumberFormat.getNumberInstance();
        m_1DP.setMinimumFractionDigits(1);
        m_1DP.setMaximumFractionDigits(1);
        m_2DP = NumberFormat.getNumberInstance();
        m_2DP.setMinimumFractionDigits(2);
        m_2DP.setMaximumFractionDigits(2);
        String string = System.getProperty("elx.glintpcl.dpi");
        String string2 = System.getProperty("elx.glintpcl.color");
        try {
            if (string != null) {
                int n = Integer.parseInt(string);
                if (n == 75 || n == 100 || n == 150 || n == 200 || n == 300 || n == 600) {
                    DPI = n;
                } else {
                    ElxLoggerJ.getLogger(GlintPCL.class).warn((Object)"elx.glintpcl.dpi must be 75,100,150,200,300 or 600 (default is 150)");
                }
            }
        }
        catch (Exception exception) {
            ElxLoggerJ.getLogger(GlintPCL.class).error((Object)("Can't read elx.glintpcl.dpi: " + string));
        }
        if (string2 != null) {
            COLOUR = "yes".equals(string2 = string2.toLowerCase()) || "true".equals(string2);
        }
    }
}

