/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.physical.lpt.LPTRenderer;
import java.io.IOException;
import java.io.OutputStream;

public class LPTPageListener
implements PageListener {
    private Result m_Result;
    private LPTRenderer m_Renderer;
    private OutputStream m_Out;

    public LPTPageListener(Result result) {
        this.m_Result = result;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        try {
            this.m_Out = this.m_Result.getOutputStream();
        }
        catch (IOException iOException) {
            throw new RenderException("Can't open output stream: " + iOException, iOException);
        }
        this.m_Renderer = new LPTRenderer(pageSource.getRenderDetails());
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void addPage(Page page) throws RenderException {
        try {
            this.m_Renderer.renderPage(page, this.m_Out);
        }
        catch (IOException iOException) {
            throw new RenderException("Can't write page: " + iOException, iOException);
        }
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        try {
            this.m_Out.close();
        }
        catch (IOException iOException) {
            throw new RenderException("Can't close stream: " + iOException, iOException);
        }
        this.m_Result = null;
        this.m_Renderer = null;
        this.m_Out = null;
    }
}

