/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.report2.engine.AbstractPipeline;
import com.elixirtech.report2.engine.LogicalPageListener;
import com.elixirtech.report2.engine.LogicalRendererEngine;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PagedLogicalRendererEngine;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.engine.Source;
import com.elixirtech.report2.engine.StreamedLogicalRendererEngine;
import com.elixirtech.report2.raw.model.RenderDetails;

public class LogicalPipeline
extends AbstractPipeline {
    public static final MimeType MIME_TYPE_1 = MimeTypes.XML();
    public static final MimeType MIME_TYPE_2 = MimeTypes.RML_LOGICAL();
    private LogicalRendererEngine m_StreamedLogicalRenderer;
    private LogicalRendererEngine m_PagedLogicalRenderer;

    public LogicalPipeline() {
        this.initFeature("Paged", "Yes");
        this.initFeature("DefaultFileExtension", "<dynamic>");
        this.m_StreamedLogicalRenderer = new StreamedLogicalRendererEngine();
        this.m_PagedLogicalRenderer = new PagedLogicalRendererEngine();
    }

    @Override
    public LogicalRendererEngine getLogicalRendererEngine(Source source) {
        boolean bl = true;
        RenderDetails renderDetails = source.getRawReport().getRenderDetails(MIME_TYPE_2.value());
        if (renderDetails == null) {
            renderDetails = source.getRawReport().getRenderDetails(MIME_TYPE_1.value());
        }
        if (renderDetails != null) {
            bl = renderDetails.isSet("Paged");
        }
        this.setFeature("Paged", bl ? "Yes" : "No");
        if (bl) {
            return this.m_PagedLogicalRenderer;
        }
        return this.m_StreamedLogicalRenderer;
    }

    @Override
    public PageListener getPageListener(Result result) {
        return new LogicalPageListener(result);
    }

    @Override
    public String getFeature(String string) {
        String string2 = super.getFeature(string);
        if (string.equals("DefaultFileExtension") && string2.equals("<dynamic>")) {
            if (super.getFeature("Paged").equals("Yes")) {
                return ".paged.rml";
            }
            return ".streamed.rml";
        }
        return string2;
    }

    @Override
    public void dispose() {
        this.m_StreamedLogicalRenderer = null;
        this.m_PagedLogicalRenderer = null;
        super.dispose();
    }
}

