/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.engine.PCLStream;
import com.elixirtech.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PCLFont {
    private Integer m_Id;
    private Integer m_TypeFace;
    private String m_Symbols;
    private Boolean m_Fixed;
    private Boolean m_Condensed;
    private ByteHolder m_Header;
    private List<ByteHolder> m_Bytes = new ArrayList<ByteHolder>();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PCLFont.class);

    public void setId(Integer n) {
        this.m_Id = n;
    }

    public void setSymbols(String string) {
        this.m_Symbols = string;
    }

    public void setTypeFace(Integer n) {
        this.m_TypeFace = n;
    }

    public void setFixed(Boolean bl) {
        this.m_Fixed = bl;
    }

    public void setCondensed(Boolean bl) {
        this.m_Condensed = bl;
    }

    public void selectFont(PCLStream pCLStream, String string, boolean bl, boolean bl2) {
        if (this.m_TypeFace != null && this.m_Symbols != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\u001b(" + this.m_Symbols);
            stringBuffer.append("\u001b(s");
            if (Boolean.TRUE.equals(this.m_Fixed)) {
                stringBuffer.append("0p");
                stringBuffer.append(string + "h");
            } else {
                stringBuffer.append("1p");
                stringBuffer.append(string + "v");
            }
            if (Boolean.TRUE.equals(this.m_Condensed)) {
                stringBuffer.append("4s");
            } else if (bl2) {
                stringBuffer.append("1s");
            } else {
                stringBuffer.append("0s");
            }
            if (bl) {
                stringBuffer.append("3b");
            } else {
                stringBuffer.append("0b");
            }
            stringBuffer.append(this.m_TypeFace + "T");
            pCLStream.add(stringBuffer.toString());
        } else {
            pCLStream.add("\u001b(0N\u001b(" + this.m_Id + "X");
        }
    }

    public void setHeader(String string) {
        this.m_Header = new ByteHolder(string);
    }

    public void addBytes(String string) {
        this.m_Bytes.add(new ByteHolder(string));
    }

    public void writeHeader(PCLStream pCLStream) {
        if (this.m_Header != null) {
            pCLStream.add(this.getBytes(this.m_Header));
        }
    }

    public void writeBytes(PCLStream pCLStream) {
        for (ByteHolder byteHolder : this.m_Bytes) {
            pCLStream.add(this.getBytes(byteHolder));
        }
    }

    private byte[] getBytes(ByteHolder byteHolder) {
        if (byteHolder.bytes == null) {
            try {
                byteHolder.bytes = FileUtil.loadBytes(new File(byteHolder.name));
            }
            catch (IOException iOException) {
                m_Log.error((Object)("Can't load font bytes from " + byteHolder.name));
            }
        }
        return byteHolder.bytes;
    }

    private static class ByteHolder {
        public String name;
        public byte[] bytes;

        public ByteHolder(String string) {
            this.name = string;
        }
    }
}

