/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.graphics.font.Font;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.graphics.font.IFontMeasurerFactory;
import com.elixirtech.report2.engine.PCLCharWidthTables;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PCLFontMeasurerFactory
implements IFontMeasurerFactory {
    private Map<Font, IFontMeasurer> m_Map = new HashMap<Font, IFontMeasurer>();
    private static FontRenderContext m_FRC = new FontRenderContext(null, true, true);
    private static PCLCharWidthTables m_Tables = new PCLCharWidthTables();

    @Override
    public IFontMeasurer getInstance(Font font) {
        IFontMeasurer iFontMeasurer = this.m_Map.get(font);
        if (iFontMeasurer == null) {
            iFontMeasurer = new PCLFontMeasurer(font);
            this.m_Map.put(font, iFontMeasurer);
        }
        return iFontMeasurer;
    }

    private static class PCLFontMeasurer
    implements IFontMeasurer {
        private java.awt.Font m_Font;
        private LineMetrics m_LineMetrics;

        public PCLFontMeasurer(Font font) {
            int n = font.isBold() ? 1 : 0;
            this.m_Font = new java.awt.Font(font.getName(), n |= font.isItalic() ? 2 : 0, font.getSize() / 20);
            this.m_Font = this.m_Font.deriveFont((float)font.getSize() / 20.0f);
            this.m_LineMetrics = this.m_Font.getLineMetrics("Sample characters", m_FRC);
        }

        @Override
        public float getWidth(String string) {
            if (StringUtil.isEmpty(string)) {
                return 0.0f;
            }
            return this.getSpacedWidth(string);
        }

        @Override
        public float getSpacedWidth(String string) {
            if (string == null || string.length() == 0) {
                return 0.0f;
            }
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] <= '\u00ff') continue;
                return this.getBasicWidth(string);
            }
            int[] nArray = this.getWidths();
            if (nArray == null) {
                return this.getBasicWidth(string);
            }
            long l = 0L;
            for (int i = 0; i < cArray.length; ++i) {
                l += (long)nArray[cArray[i]];
            }
            float f = (float)(l * (long)this.m_Font.getSize()) / 20.0f;
            float f2 = this.getBasicWidth(string);
            return (f + f2) / 2.0f;
        }

        private float getBasicWidth(String string) {
            return (float)this.m_Font.getStringBounds(string, m_FRC).getWidth() * 20.0f;
        }

        private int[] getWidths() {
            String string = this.m_Font.getName();
            ArrayList<int[]> arrayList = m_Tables.getCharWidthTablesArrayList();
            if ("Serif".equals(string) || string.startsWith("Times")) {
                if (this.m_Font.isBold() && this.m_Font.isItalic()) {
                    return (int[])arrayList.get(3);
                }
                if (this.m_Font.isBold()) {
                    return (int[])arrayList.get(1);
                }
                if (this.m_Font.isItalic()) {
                    return (int[])arrayList.get(2);
                }
                return (int[])arrayList.get(0);
            }
            return null;
        }

        @Override
        public float getWidth(String string, int n, int n2) {
            return this.getWidth(string.substring(n, n + n2));
        }

        @Override
        public float getWidth(char[] cArray, int n, int n2) {
            return this.getWidth(new String(cArray, n, n2));
        }

        @Override
        public float getHeight() {
            return this.m_LineMetrics.getHeight() * 20.0f;
        }

        @Override
        public float getAscent() {
            return this.m_LineMetrics.getAscent() * 20.0f;
        }

        @Override
        public float getDescent() {
            return this.m_LineMetrics.getDescent() * 20.0f;
        }

        @Override
        public float getLeading() {
            return this.m_LineMetrics.getLeading() * 20.0f;
        }

        @Override
        public float getCharWidth(char c) {
            return this.getWidth(new char[]{c}, 0, 1);
        }
    }
}

