/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.physical.pdf.PDFGenerator;
import com.elixirtech.util.FileUtil;
import java.io.IOException;
import java.io.OutputStream;

public class PDFPageListener
implements PageListener {
    private Result m_Result;
    private PDFGenerator m_Generator;
    private OutputStream m_Out;
    private PageSequence m_CurrentPS;

    public PDFPageListener(Result result) {
        this.m_Result = result;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        try {
            this.m_Out = this.m_Result.getOutputStream();
            this.m_Generator = new PDFGenerator(this.m_Out);
            this.m_Generator.startReport(pageSource);
        }
        catch (IOException iOException) {
            throw new RenderException("Can't open output stream: " + iOException, iOException);
        }
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
        if (this.isReceiving()) {
            if (pageSequence.isResetPageCount() && this.m_CurrentPS != null) {
                this.m_Generator.completePageCountTemplate(this.m_CurrentPS.getCachedPageCount());
            }
            this.m_CurrentPS = pageSequence;
        }
    }

    @Override
    public void addPage(Page page) throws RenderException {
        if (this.isReceiving()) {
            try {
                this.m_Generator.addPage(page);
            }
            catch (Throwable throwable) {
                FileUtil.close(this.m_Out);
                this.dispose();
                if (throwable instanceof RenderException) {
                    throw (RenderException)throwable;
                }
                throw new RenderException("Error rendering PDF: " + throwable, throwable);
            }
        }
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        if (this.isReceiving()) {
            if (this.m_CurrentPS != null) {
                this.m_Generator.completePageCountTemplate(this.m_CurrentPS.getCachedPageCount());
            }
            this.m_Generator.endReport(pageSource);
            FileUtil.close(this.m_Out);
            this.dispose();
        }
    }

    private boolean isReceiving() {
        return this.m_Generator != null;
    }

    private void dispose() {
        this.m_Result = null;
        this.m_Generator = null;
        this.m_Out = null;
        this.m_CurrentPS = null;
    }
}

