/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.physical.ppt.PPTRenderer;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RenderDetails;
import java.io.IOException;
import java.io.OutputStream;

public class PPTXPageListener
implements PageListener {
    private Result m_Result;
    private PPTRenderer m_Renderer;
    private RenderDetails m_RenderDetails;
    private OutputStream m_Out;

    public PPTXPageListener(Result result) {
        this.m_Result = result;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        try {
            this.m_Out = this.m_Result.getOutputStream();
            this.m_RenderDetails = pageSource.getRenderDetails();
        }
        catch (IOException iOException) {
            throw new RenderException("Can't open output stream: " + iOException, iOException);
        }
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void addPage(Page page) throws RenderException {
        if (this.m_Renderer == null) {
            try {
                PageSetup pageSetup = page.getPageSetup();
                this.m_Renderer = new PPTRenderer(this.m_RenderDetails, pageSetup);
            }
            catch (IOException iOException) {
                throw new RenderException("Can't construct pptx: " + iOException, iOException);
            }
        }
        try {
            this.m_Renderer.addPage(page);
        }
        catch (IOException iOException) {
            throw new RenderException("Can't write page: " + iOException, iOException);
        }
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        if (this.m_Renderer != null) {
            try {
                this.m_Renderer.endReport(this.m_Out);
                this.m_Out.close();
            }
            catch (IOException iOException) {
                throw new RenderException("Can't close stream: " + iOException, iOException);
            }
        }
        this.m_Result = null;
        this.m_Renderer = null;
        this.m_Out = null;
    }
}

