/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.glint.g2d.GlintGraphics2D;
import com.elixirtech.report2.engine.EyeRenderer;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.raw.model.PageSetup;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;

public final class PSNonThreadedPrintable
implements Pageable,
Printable {
    private int m_PageCount;
    private PrintService m_PrintService;
    private HashPrintRequestAttributeSet m_AttributeSet;
    private EyeRenderer m_Renderer;
    private List<HPage> m_Pages;
    private Exception m_Exception;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PSNonThreadedPrintable.class);

    public PSNonThreadedPrintable(PageSource pageSource, PrintService printService, HashPrintRequestAttributeSet hashPrintRequestAttributeSet) {
        this(pageSource, printService, hashPrintRequestAttributeSet, true);
    }

    public PSNonThreadedPrintable(PageSource pageSource, PrintService printService, HashPrintRequestAttributeSet hashPrintRequestAttributeSet, boolean bl) {
        this.m_PrintService = printService;
        this.m_AttributeSet = hashPrintRequestAttributeSet;
        this.m_Renderer = new EyeRenderer(bl);
        this.m_Renderer.startReport(pageSource);
        this.m_Pages = new ArrayList<HPage>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        m_Log.debug((Object)"run");
        try {
            DocPrintJob docPrintJob = this.m_PrintService.createPrintJob();
            SimpleDoc simpleDoc = new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
            docPrintJob.print(simpleDoc, this.m_AttributeSet);
        }
        catch (PrintException printException) {
            m_Log.error((Object)("Error while printing: " + printException), (Throwable)printException);
            PSNonThreadedPrintable pSNonThreadedPrintable = this;
            synchronized (pSNonThreadedPrintable) {
                this.m_Exception = printException;
            }
        }
    }

    public Exception getException() {
        return this.m_Exception;
    }

    public void addPage(Page page) {
        PageSetup pageSetup = page.getPageSetup();
        int n = pageSetup.getHorizontalPageCount();
        m_Log.debug((Object)("addPage(" + this.m_PageCount + ")"));
        for (int i = 0; i < n; ++i) {
            this.m_Pages.add(new HPage(this.m_PageCount, i, page));
        }
        ++this.m_PageCount;
    }

    public void endReport() throws InterruptedException {
        m_Log.debug((Object)"endReport");
        this.run();
    }

    @Override
    public int getNumberOfPages() {
        return -1;
    }

    @Override
    public Printable getPrintable(int n) {
        return this;
    }

    @Override
    public PageFormat getPageFormat(int n) {
        m_Log.debug((Object)("getPageFormat(" + n + ")"));
        HPage hPage = this.getPage(n);
        if (hPage == null) {
            return new PageFormat();
        }
        PageSetup pageSetup = hPage.page.getPageSetup();
        Paper paper = new Paper();
        PageFormat pageFormat = new PageFormat();
        if ("Landscape".equals(pageSetup.getOrientation())) {
            int n2 = pageSetup.getWidth() / 20;
            int n3 = pageSetup.getHeight() / 20;
            paper.setSize(n3, n2);
            paper.setImageableArea(0.0, 0.0, n3, n2);
            pageFormat.setOrientation(0);
        } else {
            int n4 = pageSetup.getWidth() / 20;
            int n5 = pageSetup.getHeight() / 20;
            paper.setSize(n4, n5);
            paper.setImageableArea(0.0, 0.0, n4, n5);
            pageFormat.setOrientation(1);
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        m_Log.debug((Object)("print(" + n + ")"));
        HPage hPage = this.getPage(n);
        if (hPage == null) {
            m_Log.debug((Object)"no such page");
            return 1;
        }
        try {
            this.m_Renderer.disposeCache();
            GlintGraphics2D glintGraphics2D = new GlintGraphics2D((Graphics2D)graphics);
            this.m_Renderer.renderPage(hPage.page, hPage.hpos, glintGraphics2D);
            glintGraphics2D.flush();
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error while rendering page: " + exception), (Throwable)exception);
        }
        return 0;
    }

    public void join() {
    }

    private HPage getPage(int n) {
        if (n >= this.m_Pages.size()) {
            return null;
        }
        return this.m_Pages.get(n);
    }

    private static class HPage {
        public final int pageNo;
        public final int hpos;
        public final Page page;

        public HPage(int n, int n2, Page page) {
            this.pageNo = n;
            this.hpos = n2;
            this.page = page;
        }
    }
}

