/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.engine.AbstractPipeline;
import com.elixirtech.report2.engine.LogicalRendererEngine;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PagedLogicalRendererEngine;
import com.elixirtech.report2.engine.PipelineException;
import com.elixirtech.report2.engine.PostScriptPageListener;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.engine.Source;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;

public class PostScriptPipeline
extends AbstractPipeline {
    protected LogicalRendererEngine m_LogicalRenderer;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PostScriptPipeline.class);

    public PostScriptPipeline() throws PipelineException {
        this.initFeature("DefaultFileExtension", ".ps");
        this.m_LogicalRenderer = new PagedLogicalRendererEngine();
    }

    @Override
    public LogicalRendererEngine getLogicalRendererEngine(Source source) {
        return this.m_LogicalRenderer;
    }

    @Override
    public PageListener getPageListener(Result result) {
        return new PostScriptPageListener(result);
    }

    public static MediaSizeName getNameFromMediaSize(float f, float f2) {
        try {
            f = f * 25.4f / 1440.0f;
            f2 = f2 * 25.4f / 1440.0f;
            MediaSizeName mediaSizeName = MediaSize.findMedia(f, f2, 1000);
            if (mediaSizeName != null) {
                return mediaSizeName;
            }
        }
        catch (Exception exception) {
            m_Log.warn((Object)("MediaSizeName error: width=" + f + ", height=" + f2));
        }
        return null;
    }
}

