/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.ElixirExt;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.EyeRenderer;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.PrinterUtil;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.engine.ThreadedPrintable;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.print.PrintAttribute;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RenderDetails;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.Iterator;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PrinterName;

public class PrintPageListener
implements PageListener {
    private PageSource m_PageSource;
    private ThreadedPrintable m_Printable;
    private PrintService m_PrintService;
    private HashPrintRequestAttributeSet m_AttributeSet;

    public PrintPageListener(Result result) {
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        this.m_PageSource = pageSource;
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void addPage(Page page) throws RenderException {
        if (this.m_Printable == null) {
            this.preparePrintable();
        }
        try {
            this.m_Printable.addPage(page);
        }
        catch (Exception exception) {
            throw new RenderException("Error during printing: " + exception, exception);
        }
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        this.m_Printable.endReport();
        this.m_PageSource = null;
        this.m_AttributeSet = null;
        this.m_Printable = null;
        this.m_PrintService = null;
    }

    private void preparePrintable() throws RenderException {
        RenderDetails renderDetails = this.m_PageSource.getRenderDetails();
        this.buildPrintService(renderDetails);
        if (this.m_PrintService == null) {
            throw new RenderException("Cannot locate print service");
        }
        EyeRenderer eyeRenderer = new EyeRenderer(true);
        eyeRenderer.startReport(this.m_PageSource);
        Dimension dimension = null;
        String string = renderDetails.getParameterValue("Media");
        if (string != null) {
            MediaSizeName mediaSizeName = PrinterUtil.lookup(string);
            dimension = this.getMediaSize(mediaSizeName);
        }
        this.m_Printable = new ThreadedPrintable(this.m_PageSource, this.m_PrintService, this.m_AttributeSet, dimension);
    }

    private void buildPrintService(RenderDetails renderDetails) {
        Object object;
        Serializable serializable;
        this.m_AttributeSet = new HashPrintRequestAttributeSet();
        Iterator<Parameter> iterator = renderDetails.getParameterIterator();
        while (iterator.hasNext()) {
            serializable = iterator.next();
            object = PrintAttribute.create(((Parameter)serializable).getKey(), ((Parameter)serializable).getValue());
            if (object == null) continue;
            ((PrintAttribute)object).buildAttributeSet(this.m_AttributeSet);
        }
        serializable = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
        object = renderDetails.getParameterValue("PrinterName");
        if (StringUtil.notEmpty((String)object)) {
            PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices((DocFlavor)serializable, this.m_AttributeSet);
            for (int i = 0; i < printServiceArray.length; ++i) {
                PrinterName printerName = printServiceArray[i].getAttribute(PrinterName.class);
                if (!((String)object).equals(printerName.getValue())) continue;
                this.m_PrintService = printServiceArray[i];
                break;
            }
            if (this.m_PrintService == null) {
                ElixirExt.warn("Printer: " + (String)object + " Not found");
            }
        }
        if (this.m_PrintService == null) {
            this.m_PrintService = PrintServiceLookup.lookupDefaultPrintService();
        }
    }

    private Dimension getMediaSize(MediaSizeName mediaSizeName) {
        MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
        int n = (int)(mediaSize.getX(25400) * 1440.0f);
        int n2 = (int)(mediaSize.getY(25400) * 1440.0f);
        return new Dimension(n, n2);
    }
}

