/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.MimeType;
import com.elixirtech.report2.engine.AbstractResult;
import com.elixirtech.report2.util.ByteCounterOutputStream;
import java.io.OutputStream;

public class StreamedResult
extends AbstractResult {
    protected ByteCounterOutputStream m_OutputStream;
    protected MimeType m_MimeType;
    protected Object m_Result;

    public StreamedResult(OutputStream outputStream, MimeType mimeType) {
        if (outputStream == null) {
            throw new IllegalArgumentException("Null output stream");
        }
        this.m_OutputStream = new ByteCounterOutputStream(outputStream);
        this.m_MimeType = mimeType;
        this.m_Features.put("Result.Type", "Result.Stream");
    }

    @Override
    public MimeType getMimeType() {
        return this.m_MimeType;
    }

    @Override
    public void setResult(Object object) {
        this.m_Result = object;
    }

    public Object getResult() {
        return this.m_Result;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.m_OutputStream;
    }

    public long getByteCount() {
        return this.m_OutputStream.getByteCount();
    }

    public String toString() {
        return "StreamedResult[mimeType=" + this.m_MimeType.value() + " outputStream=" + this.m_OutputStream + "]";
    }
}

