/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.g2d.GlintGraphics2D;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.EyeRenderer;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.PrinterUtil;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.raw.model.PageSetup;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;

public final class ThreadedPrintable
extends Thread
implements Pageable,
Printable {
    private PrintService m_PrintService;
    private HashPrintRequestAttributeSet m_AttributeSet;
    private EyeRenderer m_Renderer;
    private List<HPage> m_Pages;
    private boolean m_EndReport;
    private Exception m_Exception;
    private Dimension m_PhysicalPageSize;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ThreadedPrintable.class);

    public ThreadedPrintable(PageSource pageSource, PrintService printService, HashPrintRequestAttributeSet hashPrintRequestAttributeSet, Dimension dimension) {
        super("ThreadedPrintable");
        this.m_PrintService = printService;
        this.m_AttributeSet = hashPrintRequestAttributeSet;
        this.m_Renderer = new EyeRenderer(true);
        this.m_Renderer.startReport(pageSource);
        this.m_Pages = new ArrayList<HPage>();
        this.m_PhysicalPageSize = dimension;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        m_Log.debug((Object)"run");
        try {
            DocPrintJob docPrintJob = this.m_PrintService.createPrintJob();
            SimpleDoc simpleDoc = new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
            docPrintJob.print(simpleDoc, this.m_AttributeSet);
        }
        catch (PrintException printException) {
            m_Log.error((Object)("Error while printing: " + printException), (Throwable)printException);
            ThreadedPrintable threadedPrintable = this;
            synchronized (threadedPrintable) {
                this.m_Exception = printException;
            }
        }
    }

    public synchronized Exception getException() {
        return this.m_Exception;
    }

    public synchronized void addPage(Page page) throws Exception {
        if (this.m_Exception != null) {
            throw this.m_Exception;
        }
        m_Log.debug((Object)"addPage");
        PageSetup pageSetup = page.getPageSetup();
        int n = pageSetup.getHorizontalPageCount();
        for (int i = 0; i < n; ++i) {
            this.m_Pages.add(new HPage(i, page));
        }
        this.notify();
    }

    public synchronized void endReport() {
        m_Log.debug((Object)"endReport");
        this.m_EndReport = true;
        this.notify();
    }

    @Override
    public int getNumberOfPages() {
        return -1;
    }

    @Override
    public Printable getPrintable(int n) {
        return this;
    }

    @Override
    public PageFormat getPageFormat(int n) {
        m_Log.debug((Object)("getPageFormat(" + n + ")"));
        HPage hPage = this.getPage(n, false);
        if (hPage == null) {
            return new PageFormat();
        }
        if (this.m_PhysicalPageSize == null) {
            return PrinterUtil.getPageFormat(hPage.page);
        }
        return PrinterUtil.getScaledPageFormat(hPage.page, this.m_PhysicalPageSize);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        m_Log.debug((Object)("print(" + n + ")"));
        HPage hPage = this.getPage(n, true);
        if (hPage == null) {
            m_Log.debug((Object)"no such page");
            return 1;
        }
        try {
            Object object;
            this.m_Renderer.disposeCache();
            double d = 100.0;
            if (this.m_PhysicalPageSize != null) {
                object = PrinterUtil.getPageFormat(hPage.page);
                double d2 = pageFormat.getWidth() / ((PageFormat)object).getWidth();
                double d3 = pageFormat.getHeight() / ((PageFormat)object).getHeight();
                d = Math.min(d2, d3) * 100.0;
            }
            object = new GlintGraphics2D((Graphics2D)graphics, d);
            this.m_Renderer.renderPage(hPage.page, hPage.pos, (IGlint)object);
            ((GlintGraphics2D)object).flush();
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error while rendering page: " + exception), (Throwable)exception);
        }
        return 0;
    }

    private synchronized HPage getPage(int n, boolean bl) {
        while (n >= this.m_Pages.size() && !this.m_EndReport && this.m_Exception == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new RenderException("ThreadedPrintable interrupted");
            }
        }
        if (n < this.m_Pages.size()) {
            HPage hPage = this.m_Pages.get(n);
            if (bl && n > 0) {
                this.m_Pages.set(n - 1, null);
            }
            return hPage;
        }
        return null;
    }

    private static class HPage {
        public int pos;
        public Page page;

        public HPage(int n, Page page) {
            this.pos = n;
            this.page = page;
        }
    }
}

