/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.html;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.report2.html.HTMLElement;
import com.elixirtech.report2.html.HTMLPage;
import com.elixirtech.report2.html.IOutputter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTMLOutputter
implements IOutputter {
    public static final String DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Strict//EN\">";
    public static final String META = "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">";
    public static final String AUTHOR = "<meta name=\"author\" content=\"Elixir Report\">";
    private boolean m_SkipHeaders;
    private String m_BaseURL;
    private String m_ExtraHeaders = "";
    private static final Pattern DELAYED = Pattern.compile("(.*)\\$\\{\\#\\#([0-9]+)\\}(.*)");
    protected static final String NL = System.getProperty("line.separator");

    public HTMLOutputter(boolean bl) {
        this.m_SkipHeaders = bl;
    }

    public void addHeaders(String string) {
        this.m_ExtraHeaders = string;
    }

    public void setBaseURL(String string) {
        this.m_BaseURL = string;
    }

    @Override
    public String getBaseURL() {
        return this.m_BaseURL;
    }

    @Override
    public void output(HTMLPage hTMLPage, OutputStream outputStream) throws IOException {
        assert (hTMLPage != null);
        this.output(hTMLPage, (Writer)new OutputStreamWriter(outputStream, "UTF-8"));
    }

    @Override
    public void output(HTMLPage hTMLPage, Writer writer) throws IOException {
        assert (hTMLPage != null);
        if (this.m_SkipHeaders) {
            HTMLElement hTMLElement = hTMLPage.getBody();
            Iterator<Object> iterator = hTMLElement.getChildren();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof String) {
                    writer.write(HTMLOutputter.safeOutput((String)object));
                } else {
                    this.output((HTMLElement)object, writer);
                }
                writer.write(NL);
            }
        } else {
            writer.write(DOCTYPE);
            writer.write(NL);
            writer.write("<html>");
            writer.write(NL);
            HTMLElement hTMLElement = hTMLPage.getHead();
            this.output(hTMLElement, writer);
            writer.write(NL);
            this.output(hTMLPage.getBody(), writer);
            writer.write("</html>");
        }
        writer.flush();
    }

    @Override
    public void output(HTMLElement hTMLElement, OutputStream outputStream) throws IOException {
        assert (hTMLElement != null);
        this.output(hTMLElement, (Writer)new OutputStreamWriter(outputStream, "UTF-8"));
    }

    @Override
    public void output(HTMLElement hTMLElement, Writer writer) throws IOException {
        String string = hTMLElement.getName();
        if ("p".equals(string)) {
            writer.write("<p>");
        } else if ("br".equals(string)) {
            writer.write("<br>");
        } else {
            writer.write("<" + string + " ");
            Map<String, String> map = hTMLElement.getAttributes();
            Set<Map.Entry<String, String>> set = map.entrySet();
            for (Map.Entry<String, String> object : set) {
                String string2 = object.getKey();
                String string3 = object.getValue();
                writer.write(string2 + "=\"" + string3 + "\" ");
            }
            writer.write(">");
            writer.write(NL);
            if ("head".equals(string)) {
                writer.write(META);
                writer.write(NL);
                writer.write(AUTHOR);
                writer.write(NL);
            }
            Iterator<Object> iterator = hTMLElement.getChildren();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof String) {
                    writer.write(HTMLOutputter.safeOutput((String)object));
                } else {
                    this.output((HTMLElement)object, writer);
                }
                writer.write(NL);
            }
            if ("head".equals(string) && StringUtil.notEmpty(this.m_ExtraHeaders)) {
                writer.write(this.m_ExtraHeaders);
                writer.write(NL);
            }
            writer.write("</" + string + ">");
        }
    }

    public static String safeOutput(String string) {
        String string2 = HTMLOutputter.escapeElementEntities(string);
        return HTMLOutputter.delayedSubstitutions(string2);
    }

    private static String escapeElementEntities(String string) {
        StringBuffer stringBuffer = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            String string2 = switch (c) {
                case '<' -> "&lt;";
                case '>' -> "&gt;";
                case '&' -> "&amp;";
                default -> null;
            };
            if (stringBuffer == null) {
                if (string2 == null) continue;
                stringBuffer = new StringBuffer(string.length() + 20);
                stringBuffer.append(string.substring(0, i));
                stringBuffer.append(string2);
                continue;
            }
            if (string2 == null) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    public static String delayedSubstitutions(String string) {
        int n = string.indexOf("${##");
        if (n < 0) {
            return string;
        }
        Matcher matcher = DELAYED.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            return string2 + "<script type=\"text/javascript\">document.write(totals[" + string3 + "]);</script>" + string4;
        }
        return string;
    }
}

