/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.html;

import com.elixirtech.report2.html.HTMLElement;
import com.elixirtech.report2.html.Style;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class HTMLPage {
    protected int m_X;
    protected int m_Y;
    protected HTMLElement m_Root;
    protected HTMLElement m_Head;
    protected HTMLElement m_HeadStyle;
    protected HTMLElement m_Body;
    protected String m_Filename;
    protected String m_Linkname;
    protected Stack<HTMLElement> m_BodyStack = new Stack();
    protected Map<String, String> m_TextStyles = new HashMap<String, String>();
    protected Map<String, String> m_RectStyles = new HashMap<String, String>();
    protected static final String NL = System.getProperty("line.separator");

    public HTMLPage(String string, String string2, String string3) {
        this.m_Filename = string2;
        this.m_Linkname = string3;
        this.m_Root = new HTMLElement("html");
        this.m_Head = this.m_Root.addChild("head");
        HTMLElement hTMLElement = this.m_Head.addChild("title");
        hTMLElement.addText(string);
        this.m_Body = this.m_Root.addChild("body");
    }

    public void addStylesheet(String string) {
        HTMLElement hTMLElement = this.m_Head.addChild("link");
        hTMLElement.addAttribute("href", string);
        hTMLElement.addAttribute("rel", "stylesheet");
        hTMLElement.addAttribute("type", "text/css");
    }

    public void addStyle(String string, String string2) {
        if (this.m_HeadStyle == null) {
            this.m_HeadStyle = this.m_Head.addChild("style");
            this.m_HeadStyle.addAttribute("type", "text/css");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("{");
        stringBuilder.append(string2);
        stringBuilder.append("}");
        stringBuilder.append(NL);
        this.m_HeadStyle.addText(stringBuilder.toString());
    }

    public void addJavaScript(String string) {
        HTMLElement hTMLElement = this.m_Head.addChild("script");
        hTMLElement.addAttribute("type", "text/javascript");
        hTMLElement.addAttribute("src", string);
    }

    public String getTextClass(Style style) {
        String string = style.toString();
        String string2 = this.m_TextStyles.get(string);
        if (string2 != null) {
            return string2;
        }
        String string3 = "elx-text-" + this.m_TextStyles.size();
        this.m_TextStyles.put(string, string3);
        this.addStyle("." + string3, string);
        return string3;
    }

    public String getRectClass(Style style) {
        String string = style.toString();
        String string2 = this.m_RectStyles.get(string);
        if (string2 != null) {
            return string2;
        }
        String string3 = "elx-rect-" + this.m_RectStyles.size();
        this.m_RectStyles.put(string, string3);
        this.addStyle("." + string3, string);
        return string3;
    }

    public HTMLElement pushBody(String string) {
        this.m_BodyStack.push(this.m_Body);
        this.m_Body = this.m_Body.addChild(string);
        return this.m_Body;
    }

    public void popBody() {
        this.m_Body = this.m_BodyStack.pop();
    }

    public String getFilename() {
        return this.m_Filename;
    }

    public String getLinkname() {
        return this.m_Linkname;
    }

    public HTMLElement getHead() {
        return this.m_Head;
    }

    public HTMLElement getBody() {
        return this.m_Body;
    }

    public int getX() {
        return this.m_X;
    }

    public int getY() {
        return this.m_Y;
    }

    public void offsetX(int n) {
        this.m_X += n;
    }

    public void offsetY(int n) {
        this.m_Y += n;
    }
}

