/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.html;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.glint.GlintInput;
import com.elixirtech.glint.g2d.GlintGraphics2D;
import com.elixirtech.report2.logical.model.Glint;
import com.elixirtech.report2.logical.model.SVG;
import com.elixirtech.svg.SVGToImage;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ImageUtil {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ImageUtil.class);

    public static BufferedImage clip(BufferedImage bufferedImage, Dimension dimension, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        if (n2 <= dimension.width && n3 <= dimension.height) {
            return bufferedImage;
        }
        int n4 = 0;
        int n5 = 0;
        if ((n & 2) != 0) {
            n4 = Math.max(0, n2 - dimension.width) / 2;
        } else if ((n & 4) != 0) {
            n4 = Math.max(0, n2 - dimension.width);
        }
        if ((n & 0x10) != 0) {
            n5 = Math.max(0, n3 - dimension.height) / 2;
        } else if ((n & 0x20) != 0) {
            n5 = Math.max(0, n3 - dimension.height);
        }
        int n6 = Math.min(n2, dimension.width);
        int n7 = Math.min(n3, dimension.height);
        return bufferedImage.getSubimage(n4, n5, n6, n7);
    }

    public static BufferedImage getImage(Glint glint) {
        BufferedImage bufferedImage = new BufferedImage(glint.getWidth() / 20, glint.getHeight() / 20, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        GlintGraphics2D glintGraphics2D = new GlintGraphics2D(graphics2D);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(glint.getByteArray().getBytes());
            GlintInput.read(byteArrayInputStream, true, glintGraphics2D);
            graphics2D.dispose();
            return bufferedImage;
        }
        catch (IOException iOException) {
            m_Log.error((Object)("Glint Render error: " + iOException));
            return null;
        }
    }

    public static BufferedImage getImage(SVG sVG) {
        return SVGToImage.convert(sVG.getDocument(), new Dimension(sVG.getWidth() / 20, sVG.getHeight() / 20));
    }
}

