/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.html;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.util.StringStepper;
import com.elixirtech.graphics.WritingMode;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.graphics.grid.Strip;
import com.elixirtech.report2.RenderConstants;
import com.elixirtech.report2.html.HTMLConstants;
import com.elixirtech.report2.html.HTMLElement;
import com.elixirtech.report2.html.HTMLPage;
import com.elixirtech.report2.html.IOutputter;
import com.elixirtech.report2.html.PlainHTMLImage;
import com.elixirtech.report2.html.Style;
import com.elixirtech.report2.html.StyleBuilder;
import com.elixirtech.report2.logical.model.Body;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.Column;
import com.elixirtech.report2.logical.model.Columns;
import com.elixirtech.report2.logical.model.Grid;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageFooter;
import com.elixirtech.report2.logical.model.PageHeader;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.physical.glint.GGrid;
import com.elixirtech.report2.physical.glint.GridRenderer;
import com.elixirtech.report2.raw.model.Image;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.util.VariableSubstitution;
import com.elixirtech.tree.CellStructure;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;

public class PlainHTMLGenerator
implements HTMLConstants {
    private LogicalReport m_Report;
    private StyleBuilder m_StyleBuilder;
    private IOutputter m_Outputter;
    private VariableSubstitution m_VariableSubstitution = new VariableSubstitution();
    private String m_PageNumber;
    private String m_PageCount;
    private HTMLPage m_Page;

    public PlainHTMLGenerator(LogicalReport logicalReport, IOutputter iOutputter) {
        this.m_Report = logicalReport;
        this.m_StyleBuilder = new StyleBuilder();
        this.m_Outputter = iOutputter;
    }

    public IOutputter getOutputter() {
        return this.m_Outputter;
    }

    public void renderPage(Page page) {
        Map<String, String> map = this.m_VariableSubstitution.getMap();
        this.m_PageNumber = Integer.toString(page.getPageNumber());
        this.m_PageCount = Integer.toString(page.getPageCount());
        map.put("#", this.m_PageNumber);
        map.put("##", this.m_PageCount);
        map.put("@", this.m_PageNumber + " of " + this.m_PageCount);
        HTMLPage hTMLPage = this.newPage(this.getTitle(), null);
        this.renderPageContents(page, hTMLPage);
    }

    public void writePages(OutputStream outputStream) throws IOException {
        if (this.m_Page != null) {
            this.m_Outputter.output(this.m_Page, outputStream);
        }
    }

    protected void renderPageContents(Page page, HTMLPage hTMLPage) {
        PageSetup pageSetup = page.getPageSetup();
        Page page2 = page.getWatermark();
        if (page2 != null) {
            this.renderPageContents(page2, hTMLPage);
        }
        hTMLPage.offsetX(-hTMLPage.getX());
        hTMLPage.offsetY(-hTMLPage.getY());
        hTMLPage.offsetX(pageSetup.getLeft() / 20);
        hTMLPage.offsetY(pageSetup.getTop() / 20);
        PageHeader pageHeader = page.getPageHeader();
        if (pageHeader != null) {
            this.renderElements(hTMLPage, pageHeader);
        }
        Body body = page.getBody();
        for (BodyPart bodyPart : body.getBodyPartList()) {
            this.renderElements(hTMLPage, bodyPart);
        }
        PageFooter pageFooter = page.getPageFooter();
        if (pageFooter != null) {
            int n = (pageSetup.getHeight() - pageSetup.getBottom() - pageFooter.getHeight()) / 20;
            hTMLPage.offsetY(n - hTMLPage.getY());
            this.renderElements(hTMLPage, pageFooter);
        }
    }

    public HTMLPage newPage(String string, String string2) {
        if (this.m_Page == null) {
            this.m_Page = new HTMLPage(string, string2, string2);
        }
        this.m_Page.offsetX(-this.m_Page.getX());
        return this.m_Page;
    }

    protected void renderElements(HTMLPage hTMLPage, LogicalElementHolder logicalElementHolder) {
        if (logicalElementHolder != null) {
            boolean bl = logicalElementHolder instanceof Columns;
            if (logicalElementHolder.getHeight() <= 0 && !bl) {
                return;
            }
            int n = hTMLPage.getX();
            int n2 = hTMLPage.getY();
            HTMLElement hTMLElement = hTMLPage.pushBody("div");
            Iterator<LogicalElement> iterator = this.m_StyleBuilder.getStyle(logicalElementHolder);
            this.m_StyleBuilder.addPositionInfo(logicalElementHolder, (Style)((Object)iterator), n, n2);
            hTMLElement.addStyle((Style)((Object)iterator));
            hTMLPage.offsetX(-n);
            hTMLPage.offsetY(-n2);
            if (bl) {
                iterator = (Columns)logicalElementHolder;
                int n3 = 0;
                int n4 = hTMLPage.getX();
                Iterator<Column> iterator2 = ((Columns)((Object)iterator)).getColumnIterator();
                while (iterator2.hasNext()) {
                    Column column = iterator2.next();
                    int n5 = this.renderColumn(hTMLPage, column);
                    n3 = Math.max(n3, n5);
                    if (iterator2.hasNext()) {
                        int n6 = (column.getWidth() + column.getSpaceAfter()) / 20;
                        hTMLPage.offsetX(n6);
                    }
                    hTMLPage.offsetY(-n5);
                }
                hTMLPage.offsetX(n4 - hTMLPage.getX());
                hTMLPage.offsetY(n3);
            } else {
                iterator = logicalElementHolder.getLogicalElementIterator();
                while (iterator.hasNext()) {
                    this.renderElement(hTMLPage, iterator.next());
                }
                hTMLPage.offsetY(logicalElementHolder.getHeight() / 20);
            }
            hTMLPage.popBody();
            hTMLPage.offsetX(n);
            hTMLPage.offsetY(n2);
        }
    }

    protected int renderColumn(HTMLPage hTMLPage, Column column) {
        int n = 0;
        Iterator<BodyPart> iterator = column.getBodyPartIterator();
        while (iterator.hasNext()) {
            BodyPart bodyPart = iterator.next();
            this.renderElements(hTMLPage, bodyPart);
            int n2 = (bodyPart.getHeight() + bodyPart.getSpaceAfter()) / 20;
            n += n2;
        }
        return n;
    }

    protected void renderElement(HTMLPage hTMLPage, LogicalElement logicalElement) {
        if (logicalElement == null) {
            return;
        }
        if (logicalElement instanceof Rectangle) {
            Object object;
            Rectangle rectangle = (Rectangle)logicalElement;
            Color color = StandardColor.lookup(rectangle.getBackgroundColor());
            if (color.getAlpha() > 0 || rectangle.getBorderStyle() != null) {
                object = hTMLPage.getBody().addChild("div");
                Style style = this.m_StyleBuilder.getStyle(rectangle);
                style.add("position", "absolute");
                String string = hTMLPage.getRectClass(style);
                ((HTMLElement)object).addAttribute("class", string);
                Style style2 = new Style();
                this.m_StyleBuilder.addRectPositionInfo(rectangle, style2, hTMLPage.getX(), hTMLPage.getY());
                style2.remove("position");
                ((HTMLElement)object).addStyle(style2);
            }
            object = rectangle.getLogicalElementIterator();
            while (object.hasNext()) {
                this.renderElement(hTMLPage, (LogicalElement)object.next());
            }
        } else if (logicalElement instanceof Grid) {
            Grid grid = (Grid)logicalElement;
            GGrid gGrid = GridRenderer.buildGrid(grid);
            gGrid.calculate();
            HTMLElement hTMLElement = hTMLPage.getBody().addChild("div");
            String string = grid.getURL();
            String string2 = grid.getURLTarget();
            String string3 = grid.getURLDescription();
            boolean bl = StringUtil.notEmpty(string);
            Style style = new Style();
            this.m_StyleBuilder.addPositionInfo(grid, style, hTMLPage.getX(), hTMLPage.getY());
            hTMLElement.addStyle(style);
            Dimension dimension = gGrid.getBoxSize();
            int n = gGrid.getBoxRows();
            int n2 = gGrid.getBoxColumns();
            int n3 = grid.getLeft() + gGrid.getXOffset() / 2;
            int n4 = grid.getTop() + gGrid.getYOffset() / 2;
            CellStructure cellStructure = new CellStructure(null, n2, n);
            WritingMode writingMode = WritingMode.get(grid.getWritingMode());
            if (writingMode == WritingMode.LR_TB) {
                PlainHTMLGenerator.renderBoxesLRTB(gGrid, cellStructure);
            } else if (writingMode == WritingMode.RL_TB) {
                PlainHTMLGenerator.renderBoxesRLTB(gGrid, cellStructure);
            } else if (writingMode == WritingMode.TB_RL) {
                PlainHTMLGenerator.renderBoxesTBRL(gGrid, cellStructure);
            } else if (writingMode == WritingMode.TB_LR) {
                PlainHTMLGenerator.renderBoxesTBLR(gGrid, cellStructure);
            }
            CellStructure.Cell cell = new CellStructure.Cell("");
            for (int i = 0; i < n; ++i) {
                int n5 = n4 + i * dimension.height;
                for (int j = 0; j < n2; ++j) {
                    CellStructure.Cell cell2 = cellStructure.getCell(i, j);
                    if (cell2 == null) {
                        cell2 = cell;
                    }
                    int n6 = cell2.colSpan * dimension.width;
                    int n7 = n3 + j * dimension.width;
                    Style style3 = this.m_StyleBuilder.getCellStyle(grid);
                    this.m_StyleBuilder.addPositionInfo(style3, n7, n5, n6, dimension.height);
                    HTMLElement hTMLElement2 = hTMLPage.getBody().addChild("div");
                    hTMLElement2.addStyle(style3);
                    if (bl) {
                        HTMLElement hTMLElement3 = new HTMLElement("a");
                        hTMLElement3.addAttribute("href", string);
                        if (StringUtil.notEmpty(string2)) {
                            hTMLElement3.addAttribute("target", string2);
                        }
                        if (StringUtil.notEmpty(string3)) {
                            hTMLElement3.addAttribute("title", string3);
                        }
                        hTMLElement3.addRawText((String)cell2.data);
                        hTMLElement2.addChild(hTMLElement3);
                        continue;
                    }
                    hTMLElement2.addRawText((String)cell2.data);
                }
            }
        } else if (logicalElement instanceof Text) {
            Text text = (Text)logicalElement;
            HTMLElement hTMLElement = hTMLPage.getBody().addChild("div");
            Style style = this.m_StyleBuilder.getStyle(text);
            style.add("position", "absolute");
            String string = hTMLPage.getTextClass(style);
            hTMLElement.addAttribute("class", string);
            Style style4 = new Style();
            this.m_StyleBuilder.addPositionInfo(text, style4, hTMLPage.getX(), hTMLPage.getY());
            style4.remove("position");
            hTMLElement.addStyle(style4);
            String string4 = text.getText();
            if (StringUtil.notEmpty(string4)) {
                String string5 = this.substituteVariables(string4);
                String string6 = text.getURL();
                if (StringUtil.notEmpty(string6)) {
                    HTMLElement hTMLElement4 = new HTMLElement("a");
                    hTMLElement4.addAttribute("href", string6);
                    String string7 = text.getURLTarget();
                    String string8 = text.getURLDescription();
                    if (StringUtil.notEmpty(string7)) {
                        hTMLElement4.addAttribute("target", string7);
                    }
                    if (StringUtil.notEmpty(string8)) {
                        hTMLElement4.addAttribute("title", string8);
                    }
                    hTMLElement4.addRawText(string5);
                    hTMLElement.addChild(hTMLElement4);
                } else {
                    hTMLElement.addRawText(string5);
                }
            }
        } else if (logicalElement instanceof com.elixirtech.report2.logical.model.Image) {
            com.elixirtech.report2.logical.model.Image image = (com.elixirtech.report2.logical.model.Image)logicalElement;
            RawModelElement rawModelElement = image.getRaw();
            HTMLElement hTMLElement = hTMLPage.getBody().addChild("div");
            Style style = this.m_StyleBuilder.getStyle(image);
            this.m_StyleBuilder.addPositionInfo(image, style, hTMLPage.getX(), hTMLPage.getY());
            hTMLElement.addStyle(style);
            if (rawModelElement instanceof Image) {
                PlainHTMLImage plainHTMLImage = new PlainHTMLImage();
                Image image2 = (Image)rawModelElement;
                if (!"Clip".equals(image2.getSizeMode())) {
                    plainHTMLImage.setBounds(image.getLeft() / 20, image.getTop() / 20, image.getWidth() / 20, image.getHeight() / 20);
                }
                plainHTMLImage.setSrc(image.getPicture());
                String string = image.getURL();
                if (StringUtil.notEmpty(string)) {
                    HTMLElement hTMLElement5 = new HTMLElement("a");
                    hTMLElement5.addAttribute("href", string);
                    String string9 = image.getURLTarget();
                    String string10 = image.getURLDescription();
                    if (StringUtil.notEmpty(string9)) {
                        hTMLElement5.addAttribute("target", string9);
                    }
                    if (StringUtil.notEmpty(string10)) {
                        hTMLElement5.addAttribute("title", string10);
                    }
                    hTMLElement5.addChild(plainHTMLImage);
                    hTMLElement.addChild(hTMLElement5);
                } else {
                    hTMLElement.addChild(plainHTMLImage);
                }
            }
        }
    }

    protected static void renderBoxesLRTB(GGrid gGrid, CellStructure cellStructure) {
        Strip[] stripArray = gGrid.buildStrips();
        Dimension dimension = gGrid.getBoxSize();
        IFontMeasurer iFontMeasurer = gGrid.getFontMeasurer();
        int n = 0;
        for (int i = 0; i < stripArray.length && n < gGrid.getBoxCount(); ++i) {
            Point point;
            String string = stripArray[i].getString();
            float f = iFontMeasurer.getWidth(string);
            int n2 = (int)(f / (float)dimension.width) + 1;
            if (n2 == 1) {
                point = gGrid.getBox(n);
                cellStructure.addCell(point.y, point.x, string);
                ++n;
                continue;
            }
            point = gGrid.getBox(n);
            if (point.x + n2 < gGrid.getBoxColumns()) {
                CellStructure.Cell cell = cellStructure.addCell(point.y, point.x, string);
                cell.colSpan = n2;
                n += n2;
                continue;
            }
            int n3 = gGrid.getBoxColumns() - point.x;
            int n4 = n3 * dimension.width;
            String[] stringArray = PlainHTMLGenerator.breakString(stripArray[i], n4, iFontMeasurer);
            CellStructure.Cell cell = cellStructure.addCell(point.y, point.x, stringArray[0]);
            cell.colSpan = n3;
            n += n3;
            stripArray[i] = new Strip(stringArray[1], stripArray[i].getType());
            --i;
        }
    }

    protected static void renderBoxesRLTB(GGrid gGrid, CellStructure cellStructure) {
        Strip[] stripArray = gGrid.buildStrips();
        Dimension dimension = gGrid.getBoxSize();
        IFontMeasurer iFontMeasurer = gGrid.getFontMeasurer();
        int n = 0;
        for (int i = 0; i < stripArray.length && n < gGrid.getBoxCount(); ++i) {
            Point point;
            String string = stripArray[i].getString();
            float f = iFontMeasurer.getWidth(string);
            int n2 = (int)(f / (float)dimension.width) + 1;
            if (n2 == 1) {
                point = gGrid.getBox(n);
                cellStructure.addCell(point.y, point.x, string);
                ++n;
                continue;
            }
            point = gGrid.getBox(n);
            if (point.x - n2 >= 0) {
                CellStructure.Cell cell = cellStructure.addCell(point.y, point.x - n2, string);
                cell.colSpan = n2;
                n += n2;
                continue;
            }
            int n3 = point.x + 1;
            int n4 = n3 * dimension.width;
            String[] stringArray = PlainHTMLGenerator.breakString(stripArray[i], n4, iFontMeasurer);
            CellStructure.Cell cell = cellStructure.addCell(point.y, 0, stringArray[0]);
            cell.colSpan = n3;
            n += n3;
            stripArray[i] = new Strip(stringArray[1], stripArray[i].getType());
            --i;
        }
    }

    protected static void renderBoxesTBRL(GGrid gGrid, CellStructure cellStructure) {
        StringStepper stringStepper = new StringStepper(gGrid.getText());
        for (int i = 0; !stringStepper.atEnd() && i < gGrid.getBoxCount(); ++i) {
            char c = stringStepper.getChar().charValue();
            if (c != ' ') {
                Point point = gGrid.getBox(i);
                cellStructure.addCell(point.y, point.x, String.valueOf(c));
            }
            stringStepper.advance();
        }
    }

    protected static void renderBoxesTBLR(GGrid gGrid, CellStructure cellStructure) {
        StringStepper stringStepper = new StringStepper(gGrid.getText());
        for (int i = 0; !stringStepper.atEnd() && i < gGrid.getBoxCount(); ++i) {
            char c = stringStepper.getChar().charValue();
            if (c != ' ') {
                Point point = gGrid.getBox(i);
                cellStructure.addCell(point.y, point.x, String.valueOf(c));
            }
            stringStepper.advance();
        }
    }

    protected static String[] breakString(Strip strip, int n, IFontMeasurer iFontMeasurer) {
        String string = strip.getString();
        String[] stringArray = new String[]{string, ""};
        char[] cArray = string.toCharArray();
        for (int i = 1; i < cArray.length; ++i) {
            float f = iFontMeasurer.getWidth(cArray, 0, i);
            if (!(f > (float)n)) continue;
            stringArray[0] = string.substring(0, i - 1);
            stringArray[1] = string.substring(i - 1);
            break;
        }
        return stringArray;
    }

    private String getTitle() {
        return this.m_Report.getCaption();
    }

    private String substituteVariables(String string) {
        string = StringUtil.findAndReplace(string, RenderConstants.PAGE_NUMBER_STRING, this.m_PageNumber);
        string = StringUtil.findAndReplace(string, RenderConstants.PAGE_COUNT_STRING, this.m_PageCount);
        return this.m_VariableSubstitution.substitute(string);
    }
}

