/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.html;

import com.elixirtech.report2.html.HTMLElement;
import com.elixirtech.report2.html.HTMLGenerator;
import com.elixirtech.report2.html.HTMLPage;
import com.elixirtech.report2.html.IOutputter;
import com.elixirtech.report2.html.StreamedHTMLNavigator;
import com.elixirtech.report2.html.Style;
import com.elixirtech.report2.html.TOCBuilder;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.SizableElement;
import com.elixirtech.report2.raw.model.PageSetup;
import java.io.IOException;
import java.util.Iterator;

public class StreamedHTMLGenerator
extends HTMLGenerator {
    private HTMLPage m_SinglePage;

    public StreamedHTMLGenerator(LogicalReport logicalReport, IOutputter iOutputter) {
        super(logicalReport, iOutputter, new StreamedHTMLNavigator());
    }

    @Override
    protected TOCBuilder createTOCBuilder() {
        return null;
    }

    @Override
    protected void startPage(Page page, HTMLPage hTMLPage) {
        if (this.m_BackgroundDiv) {
            Object object;
            HTMLElement hTMLElement = hTMLPage.pushBody("div");
            PageSetup pageSetup = page.getPageSetup();
            int n = pageSetup.getTop();
            Iterator<BodyPart> iterator = page.getBody().getBodyPartIterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                n += ((LogicalElementHolder)object).getTop() + ((SizableElement)object).getHeight();
            }
            object = this.m_StyleBuilder.getStreamedStyle(page, n += pageSetup.getBottom());
            hTMLElement.addStyle((Style)object);
            hTMLElement.addAttribute("class", "pagesize");
        }
    }

    @Override
    public HTMLPage newPage(String string, String string2, String string3) {
        if (this.m_SinglePage == null) {
            this.m_SinglePage = new HTMLPage(string, "index.html", string3);
        } else {
            this.m_SinglePage.offsetX(-this.m_SinglePage.getX());
        }
        return this.m_SinglePage;
    }

    @Override
    protected void save(HTMLPage hTMLPage) throws IOException {
    }

    @Override
    public void endReport() throws IOException {
        if (this.m_SinglePage != null) {
            super.save(this.m_SinglePage);
        }
        super.endReport();
    }
}

