/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.html;

import com.elixirtech.report2.html.HTMLElement;
import com.elixirtech.report2.html.HTMLOutputter;
import com.elixirtech.report2.html.HTMLPage;
import com.elixirtech.report2.html.IOutputter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;

public class XHTMLOutputter
implements IOutputter {
    public static final String XML_PREAMBLE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String DOCTYPE = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">";
    protected static final String NL = System.getProperty("line.separator");

    @Override
    public String getBaseURL() {
        return null;
    }

    @Override
    public void output(HTMLPage hTMLPage, OutputStream outputStream) throws IOException {
        this.output(hTMLPage, (Writer)new OutputStreamWriter(outputStream, "UTF-8"));
    }

    @Override
    public void output(HTMLPage hTMLPage, Writer writer) throws IOException {
        writer.write(XML_PREAMBLE);
        writer.write(NL);
        writer.write(DOCTYPE);
        writer.write(NL);
        writer.write("<html xmlns=\"http://www.w3.org/1999/xhtml\" >");
        this.output(hTMLPage.getHead(), writer);
        writer.write(NL);
        this.output(hTMLPage.getBody(), writer);
        writer.write("</html>");
        writer.flush();
    }

    @Override
    public void output(HTMLElement hTMLElement, OutputStream outputStream) throws IOException {
        assert (hTMLElement != null);
        this.output(hTMLElement, (Writer)new OutputStreamWriter(outputStream, "UTF-8"));
    }

    @Override
    public void output(HTMLElement hTMLElement, Writer writer) throws IOException {
        Object object;
        String string2 = hTMLElement.getName();
        writer.write("<" + string2 + " ");
        Map<String, String> map = hTMLElement.getAttributes();
        for (String object2 : map.keySet()) {
            object = map.get(object2);
            writer.write(object2 + "=\"" + (String)object + "\" ");
        }
        writer.write(">");
        writer.write(NL);
        Iterator<Object> iterator = hTMLElement.getChildren();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object instanceof String) {
                writer.write(HTMLOutputter.safeOutput((String)object));
            } else {
                this.output((HTMLElement)object, writer);
            }
            writer.write(NL);
        }
        writer.write("</" + string2 + ">");
    }
}

