/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.GroupNode;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.RecordScope;
import com.elixirtech.report2.RenderContainer;
import com.elixirtech.report2.data.IDataCache;
import com.elixirtech.report2.data.IDataCacheManager;
import com.elixirtech.report2.data.MasterDataCache;
import com.elixirtech.report2.data.function.Average;
import com.elixirtech.report2.data.function.Count;
import com.elixirtech.report2.data.function.Function;
import com.elixirtech.report2.data.function.Max;
import com.elixirtech.report2.data.function.Min;
import com.elixirtech.report2.data.function.StandardDeviation;
import com.elixirtech.report2.data.function.Sum;
import com.elixirtech.report2.data.function.Variance;
import com.elixirtech.report2.logical.Data;
import com.elixirtech.report2.logical.DataHolder;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.PagedSectionRenderer;
import com.elixirtech.report2.logical.StreamedSectionRenderer;
import com.elixirtech.report2.raw.model.Group;
import com.elixirtech.report2.raw.model.GroupHeader;
import com.elixirtech.report2.raw.model.Section;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class DataSink
implements DataListener,
Data,
Function.IDataHolder,
com.elixirtech.data2.Data {
    public static final int STATE_PRE_HEADER = 1;
    public static final int STATE_HEADER = 2;
    public static final int STATE_GROUP_HEADER = 3;
    public static final int STATE_DETAIL = 4;
    public static final int STATE_GROUP_FOOTER = 5;
    public static final int STATE_FOOTER = 6;
    public static final int STATE_POST_FOOTER = 7;
    private StreamedSectionRenderer m_Renderer;
    private String m_Name;
    private IDataSource m_DataSource;
    private DataTable m_DataTable;
    private DataSchema m_DataSchema;
    private PushContext m_Context;
    private Section m_Section;
    private List<DataGroup> m_ToDoGroups = new ArrayList<DataGroup>();
    private Stack<DataGroup> m_GroupStack = new Stack();
    private DataRecord m_CurrentRecord;
    private RecordScope m_RecordScope;
    private int m_CurrentIndex = -1;
    private Group m_StartingGroup;
    private Group m_EndingGroup;
    private int m_State;
    private MasterDataCache m_MasterDataCache;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DataSink.class);

    public DataSink(StreamedSectionRenderer streamedSectionRenderer, Section section, String string, PushContext pushContext) {
        this.m_Renderer = streamedSectionRenderer;
        this.m_Section = section;
        this.m_Name = string;
        this.m_Context = pushContext;
        this.m_State = 1;
    }

    @Override
    public String getDataSourceName() {
        return this.m_Name;
    }

    public int getState() {
        return this.m_State;
    }

    public RecordScope getRecordScope() {
        return this.m_RecordScope;
    }

    @Override
    public void startData(IDataSource iDataSource) {
        this.m_DataSource = iDataSource;
        this.m_DataSchema = iDataSource.getSchema();
        this.m_RecordScope = new RecordScope(this.m_DataSchema);
        this.m_RecordScope.setContext(this.m_Context);
        if (this.m_DataSource instanceof DataTable) {
            this.m_DataTable = (DataTable)this.m_DataSource;
            this.m_MasterDataCache = new MasterDataCache(this);
            IDataCacheManager iDataCacheManager = RenderContainer.get(IDataCacheManager.class);
            iDataCacheManager.putCache(this.m_Name, this.m_MasterDataCache);
        }
    }

    @Override
    public void startGroup(DataGroup dataGroup) {
        this.m_ToDoGroups.add(dataGroup);
    }

    @Override
    public boolean processRecord(DataRecord dataRecord) {
        this.m_RecordScope.setData(dataRecord.getData());
        this.m_CurrentRecord = dataRecord;
        ++this.m_CurrentIndex;
        if (this.m_CurrentIndex == 0) {
            this.m_State = 2;
            this.sync();
            this.m_Renderer.renderSectionHeader();
        }
        this.processToDo();
        this.m_State = 4;
        this.sync();
        this.m_Renderer.renderDetail(this.m_Section);
        if (Thread.currentThread().isInterrupted()) {
            m_Log.warn((Object)"Interrupt detected in processRecord");
            return false;
        }
        return true;
    }

    @Override
    public void endGroup(DataGroup dataGroup) {
        this.processToDo();
        int n = dataGroup.getLevel();
        if (n < this.m_Section.getGroupCount()) {
            Group group;
            this.m_EndingGroup = group = this.m_Section.getGroup(n);
            this.m_State = 5;
            this.sync();
            this.m_Renderer.renderGroupFooter(group);
            this.m_EndingGroup = null;
        }
        this.m_GroupStack.pop();
    }

    @Override
    public void endData(IDataSource iDataSource) {
        if (this.m_CurrentIndex == -1) {
            this.m_State = 2;
            this.sync();
            this.m_Renderer.renderSectionHeader();
        }
        this.m_State = 6;
        this.sync();
        this.m_Renderer.renderSectionFooter();
        this.m_State = 7;
        this.m_CurrentRecord = null;
        this.m_DataSchema = null;
        this.m_RecordScope = null;
        if (this.m_DataSource instanceof DataTable) {
            IDataCacheManager iDataCacheManager = RenderContainer.get(IDataCacheManager.class);
            iDataCacheManager.removeCache(this.m_Name);
            this.m_MasterDataCache = null;
        }
    }

    private void sync() {
        if (this.m_MasterDataCache != null) {
            this.m_MasterDataCache.setRecordIndex(this.m_CurrentIndex);
        }
    }

    private void processToDo() {
        if (this.m_ToDoGroups.size() > 0) {
            for (DataGroup dataGroup : this.m_ToDoGroups) {
                this.m_GroupStack.push(dataGroup);
                int n = dataGroup.getLevel();
                if (n >= this.m_Section.getGroupCount()) continue;
                Group group = this.m_Section.getGroup(n);
                this.m_State = 3;
                this.m_StartingGroup = group;
                this.sync();
                this.m_Renderer.renderGroupHeader(group, false);
                this.m_StartingGroup = null;
            }
            this.m_ToDoGroups.clear();
        }
    }

    public void repeatGroupHeaders() {
        int n;
        int n2 = this.m_State;
        Stack<DataGroup> stack = new Stack<DataGroup>();
        int n3 = this.m_GroupStack.size();
        for (n = 0; n < n3; ++n) {
            stack.push(this.m_GroupStack.pop());
        }
        for (n = 0; n < n3; ++n) {
            Group group;
            GroupHeader groupHeader;
            GroupNode groupNode = (GroupNode)stack.pop();
            int n4 = groupNode.getLevel();
            this.m_GroupStack.push(groupNode);
            if (n4 >= this.m_Section.getGroupCount() || (groupHeader = (group = this.m_Section.getGroup(n4)).getGroupHeader()) == null || !groupHeader.isVisible() || !groupHeader.isRepeatSection() || this.m_StartingGroup == group || this.isOnKeepList(groupHeader) || this.alreadyOnThisPage(groupHeader)) continue;
            this.m_State = 3;
            boolean bl = groupHeader.isKeepWithNext();
            groupHeader.setKeepWithNext(false);
            this.sync();
            this.m_Renderer.renderGroupHeader(group, true);
            groupHeader.setKeepWithNext(bl);
        }
        this.m_State = n2;
    }

    public boolean isOnKeepList(GroupHeader groupHeader) {
        return ((PagedSectionRenderer)this.m_Renderer).isOnKeepList(groupHeader);
    }

    public boolean alreadyOnThisPage(GroupHeader groupHeader) {
        LogicalRenderContext logicalRenderContext = this.m_Renderer.getRenderContext();
        return logicalRenderContext.alreadyOnThisPage(groupHeader);
    }

    public int getRepeatGroupHeadersHeight() {
        int n = 0;
        for (GroupNode groupNode : this.m_GroupStack) {
            Group group;
            GroupHeader groupHeader;
            int n2 = groupNode.getLevel();
            if (n2 >= this.m_Section.getGroupCount() || (groupHeader = (group = this.m_Section.getGroup(n2)).getGroupHeader()) == null || !groupHeader.isVisible() || !groupHeader.isRepeatSection() || this.m_EndingGroup == group || this.m_StartingGroup == group) continue;
            n += groupHeader.getHeight();
        }
        return n;
    }

    @Override
    public Object getObject(String string) {
        int n = this.m_DataSchema.getColumnIndex(string);
        if (n >= 0 && this.m_CurrentRecord != null) {
            return this.m_CurrentRecord.getData(n);
        }
        m_Log.warn((Object)("getObject: No object found: " + string));
        return null;
    }

    @Override
    public String getString(String string) {
        int n = this.m_DataSchema.getColumnIndex(string);
        if (n >= 0 && this.m_CurrentRecord != null) {
            Object object = this.m_CurrentRecord.getData(n);
            if (object != null) {
                return object.toString();
            }
            return "";
        }
        m_Log.warn((Object)("getString: No object found: " + string));
        return "";
    }

    @Override
    public DataRecord getDataRecord() {
        return this.m_CurrentRecord;
    }

    @Override
    public DataTable getDataTable() {
        if (this.m_DataTable != null) {
            return this.m_DataTable;
        }
        if (this.m_DataSource == null) {
            m_Log.warn((Object)"getDataTable(): Datasource is null");
        } else {
            m_Log.warn((Object)("DataSource is a " + this.m_DataSource.getClass().getName() + " - can't get as DataTable"));
        }
        return null;
    }

    @Override
    public GroupNode getGroup() {
        DataGroup dataGroup;
        if (this.m_GroupStack.size() > 0 && (dataGroup = this.m_GroupStack.peek()) instanceof GroupNode) {
            return (GroupNode)dataGroup;
        }
        if (this.m_DataTable != null) {
            return this.m_DataTable.getGroups();
        }
        return null;
    }

    @Override
    public int getRecordIndex() {
        return this.m_CurrentIndex;
    }

    @Override
    public int getRecordCount() {
        if (this.m_DataTable != null) {
            return this.m_DataTable.getRecordCount();
        }
        m_Log.warn((Object)"getRecordCount: record count only available for DataTable");
        return 0;
    }

    @Override
    public Function getMin(String string) {
        if (this.m_DataTable != null) {
            int n = this.m_DataTable.getColumnIndex(string);
            if (n >= 0) {
                return new Min(this, n);
            }
            m_Log.warn((Object)("getMin: " + string + " not found"));
        } else {
            m_Log.warn((Object)"getMin: function only available with a DataTable");
        }
        return Function.NULL;
    }

    @Override
    public Function getMin(String string, String string2) {
        try {
            IDataCache iDataCache = this.getCache(string);
            int n = iDataCache.getColumnIndex(string2);
            if (n >= 0) {
                return new Min(iDataCache, n);
            }
            m_Log.warn((Object)("getMin(" + string + "," + string2 + ") not found"));
        }
        catch (DataException dataException) {
            m_Log.warn((Object)("getMin(" + string + "," + string2 + ") : " + dataException));
        }
        return Function.NULL;
    }

    @Override
    public Function getMax(String string) {
        if (this.m_DataTable != null) {
            int n = this.m_DataTable.getColumnIndex(string);
            if (n >= 0) {
                return new Max(this, n);
            }
            m_Log.warn((Object)("getMax: " + string + " not found"));
        } else {
            m_Log.warn((Object)"getMax: function only available with a DataTable");
        }
        return Function.NULL;
    }

    @Override
    public Function getMax(String string, String string2) {
        try {
            IDataCache iDataCache = this.getCache(string);
            int n = iDataCache.getColumnIndex(string2);
            if (n >= 0) {
                return new Max(iDataCache, n);
            }
            m_Log.warn((Object)("getMax(" + string + "," + string2 + ") not found"));
        }
        catch (DataException dataException) {
            m_Log.warn((Object)("getMax(" + string + "," + string2 + ") : " + dataException));
        }
        return Function.NULL;
    }

    @Override
    public Function getCount(String string) {
        if (this.m_DataTable != null) {
            int n = this.m_DataTable.getColumnIndex(string);
            if (n >= 0) {
                return new Count(this, n);
            }
            m_Log.warn((Object)("getCount: " + string + " not found"));
        } else {
            m_Log.warn((Object)"getCount: function only available with a DataTable");
        }
        return Function.NULL;
    }

    @Override
    public Function getCount(String string, String string2) {
        try {
            IDataCache iDataCache = this.getCache(string);
            int n = iDataCache.getColumnIndex(string2);
            if (n >= 0) {
                return new Count(iDataCache, n);
            }
            m_Log.warn((Object)("getCount(" + string + "," + string2 + ") not found"));
        }
        catch (DataException dataException) {
            m_Log.warn((Object)("getCount(" + string + "," + string2 + ") : " + dataException));
        }
        return Function.NULL;
    }

    @Override
    public Function getSum(String string) {
        if (this.m_DataTable != null) {
            int n = this.m_DataTable.getColumnIndex(string);
            if (n >= 0) {
                return new Sum(this, n);
            }
            m_Log.warn((Object)("getSum: " + string + " not found"));
        } else {
            m_Log.warn((Object)"getSum: function only available with a DataTable");
        }
        return Function.NULL;
    }

    @Override
    public Function getSum(String string, String string2) {
        try {
            IDataCache iDataCache = this.getCache(string);
            int n = iDataCache.getColumnIndex(string2);
            if (n >= 0) {
                return new Sum(iDataCache, n);
            }
            m_Log.warn((Object)("getSum(" + string + "," + string2 + ") not found"));
        }
        catch (DataException dataException) {
            m_Log.warn((Object)("getSum(" + string + "," + string2 + ") : " + dataException));
        }
        return Function.NULL;
    }

    @Override
    public Function getAverage(String string) {
        if (this.m_DataTable != null) {
            int n = this.m_DataTable.getColumnIndex(string);
            if (n >= 0) {
                return new Average(this, n);
            }
            m_Log.warn((Object)("getAverage: " + string + " not found"));
        } else {
            m_Log.warn((Object)"getAverage: function only available with a DataTable");
        }
        return Function.NULL;
    }

    @Override
    public Function getAverage(String string, String string2) {
        try {
            IDataCache iDataCache = this.getCache(string);
            int n = iDataCache.getColumnIndex(string2);
            if (n >= 0) {
                return new Average(iDataCache, n);
            }
            m_Log.warn((Object)("getAverage(" + string + "," + string2 + ") not found"));
        }
        catch (DataException dataException) {
            m_Log.warn((Object)("getAverage(" + string + "," + string2 + ") : " + dataException));
        }
        return Function.NULL;
    }

    @Override
    public Function getVariance(String string) {
        if (this.m_DataTable != null) {
            int n = this.m_DataTable.getColumnIndex(string);
            if (n >= 0) {
                return new Variance(this, n);
            }
            m_Log.warn((Object)("getVariance: " + string + " not found"));
        } else {
            m_Log.warn((Object)"getVariance: function only available with a DataTable");
        }
        return Function.NULL;
    }

    @Override
    public Function getVariance(String string, String string2) {
        try {
            IDataCache iDataCache = this.getCache(string);
            int n = iDataCache.getColumnIndex(string2);
            if (n >= 0) {
                return new Sum(iDataCache, n);
            }
            m_Log.warn((Object)("getVariance(" + string + "," + string2 + ") not found"));
        }
        catch (DataException dataException) {
            m_Log.warn((Object)("getVariance(" + string + "," + string2 + ") : " + dataException));
        }
        return Function.NULL;
    }

    @Override
    public Function getStandardDeviation(String string) {
        if (this.m_DataTable != null) {
            int n = this.m_DataTable.getColumnIndex(string);
            if (n >= 0) {
                return new StandardDeviation(this, n);
            }
            m_Log.warn((Object)("getStandardDeviation: " + string + " not found"));
        } else {
            m_Log.warn((Object)"getStandardDeviation: function only available with a DataTable");
        }
        return Function.NULL;
    }

    @Override
    public Function getStandardDeviation(String string, String string2) {
        try {
            IDataCache iDataCache = this.getCache(string);
            int n = iDataCache.getColumnIndex(string2);
            if (n >= 0) {
                return new StandardDeviation(iDataCache, n);
            }
            m_Log.warn((Object)("getStandardDeviation(" + string + "," + string2 + ") not found"));
        }
        catch (DataException dataException) {
            m_Log.warn((Object)("getStandardDeviation(" + string + "," + string2 + ") : " + dataException));
        }
        return Function.NULL;
    }

    private IDataCache getCache(String string) throws DataException {
        IDataCacheManager iDataCacheManager = RenderContainer.get(IDataCacheManager.class);
        IDataCache iDataCache = null;
        if (iDataCacheManager.hasCache(string)) {
            iDataCache = iDataCacheManager.getCache(string);
        } else {
            DataHolder dataHolder = new DataHolder(string);
            iDataCache = iDataCacheManager.loadCache(string, dataHolder.getProperties());
        }
        return iDataCache;
    }
}

