/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.RenderConstants;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.logical.IPaginator;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.raw.model.PageFooter;
import com.elixirtech.report2.raw.model.PageHeader;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.Section;

public class Paginator
implements IPaginator,
RenderConstants {
    public static final int DOWN_THEN_ACROSS = 10;
    public static final int ACROSS_THEN_DOWN = 11;
    protected Section m_Section;
    protected boolean m_Progress;
    protected PageSetup m_PageSetup;
    protected int m_Layout;
    protected int m_Y;
    protected int m_Page;
    protected int m_DeadHeight;
    protected boolean m_AtTop;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Paginator.class);

    public Paginator(Section section, boolean bl) throws RenderException {
        this.m_Section = section;
        this.m_Progress = bl && m_Log.isDebugEnabled();
        RenderStack renderStack = RenderStack.current();
        String string = this.m_Section.getPageSetup();
        this.m_PageSetup = renderStack.getPageSetup(string);
        if (this.m_PageSetup == null) {
            throw new RenderException("Section Page Setup " + string + " not found");
        }
        this.m_Layout = this.m_PageSetup.isAcrossThenDown() ? 11 : 10;
        this.m_Y = 0;
        this.setAtTop(true);
        if (this.m_Progress) {
            m_Log.debug((Object)"Starting page 1");
        }
    }

    public int getLayout() {
        return this.m_Layout;
    }

    public int getPageHeaderHeight() {
        PageHeader pageHeader;
        if (this.m_Section.isShowPageHeader() && (pageHeader = this.m_Section.getPageHeader()) != null) {
            return pageHeader.isVisible() ? pageHeader.getHeight() : 0;
        }
        return 0;
    }

    public int getPageFooterHeight() {
        PageFooter pageFooter;
        if (this.m_Section.isShowPageFooter() && (pageFooter = this.m_Section.getPageFooter()) != null) {
            return pageFooter.isVisible() ? pageFooter.getHeight() : 0;
        }
        return 0;
    }

    @Override
    public void dispose() {
        this.m_Section = null;
        this.m_PageSetup = null;
        this.m_Section = null;
    }

    public int getPageNumber() {
        return this.m_Page + 1;
    }

    @Override
    public void initAvailableHeight() {
        this.m_DeadHeight += this.m_Y;
        this.m_Y = 0;
    }

    @Override
    public int getAvailableHeight() {
        int n = this.getUsableHeight();
        n -= this.m_DeadHeight;
        n -= this.m_Y;
        return n -= this.getPageFooterHeight();
    }

    @Override
    public int getBodyHeight() {
        int n = this.getUsableHeight();
        n -= this.getPageHeaderHeight();
        return n -= this.getPageFooterHeight();
    }

    public void logState() {
        m_Log.debug((Object)("m_Y=" + this.m_Y + " m_Page=" + this.m_Page + " atTop=" + this.isAtTop() + " m_DeadHeight=" + this.m_DeadHeight));
    }

    @Override
    public boolean canFit(int n) {
        int n2 = this.getAvailableHeight();
        return n2 >= n;
    }

    @Override
    public void add(int n) {
        this.m_Y += n;
        this.setAtTop(false);
    }

    @Override
    public boolean hasColumns() {
        return false;
    }

    @Override
    public boolean hasMoreColumns() {
        return false;
    }

    @Override
    public int getColumnNumber() {
        return 1;
    }

    @Override
    public void newColumn() {
        throw new RuntimeException("Paginator doesn't support multiple columns");
    }

    public int getX() {
        return 0;
    }

    public void newPage(boolean bl) {
        this.m_Y = 0;
        this.setAtTop(true);
        this.m_Page = bl ? 0 : ++this.m_Page;
        this.m_DeadHeight = 0;
        if (this.m_Progress) {
            m_Log.debug((Object)("Starting page " + (this.m_Page + 1)));
        }
    }

    @Override
    public boolean isAtTop() {
        return this.m_AtTop;
    }

    public void setAtTop(boolean bl) {
        this.m_AtTop = bl;
    }

    public void removeBlankPage() {
        --this.m_Page;
    }

    public int getUsableHeight() {
        return this.m_PageSetup.getHeight() - this.m_PageSetup.getTop() - this.m_PageSetup.getBottom();
    }

    @Override
    public int getUsableWidth() {
        return this.m_PageSetup.getWidth() - this.m_PageSetup.getLeft() - this.m_PageSetup.getRight();
    }

    public Section getSection() {
        return this.m_Section;
    }
}

